/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Objects;
import org.apache.hudi.com.esotericsoftware.kryo.Kryo;
import org.apache.hudi.com.esotericsoftware.kryo.io.Input;
import org.apache.hudi.com.esotericsoftware.kryo.io.Output;
import org.apache.hudi.common.model.HoodieRecordLocation;

public final class HoodieRecordGlobalLocation
extends HoodieRecordLocation {
    private static final long serialVersionUID = 1L;
    private String partitionPath;

    public HoodieRecordGlobalLocation() {
    }

    public HoodieRecordGlobalLocation(String partitionPath, String instantTime, String fileId) {
        super(instantTime, fileId);
        this.partitionPath = partitionPath;
    }

    public HoodieRecordGlobalLocation(String partitionPath, String instantTime, String fileId, long position) {
        super(instantTime, fileId, position);
        this.partitionPath = partitionPath;
    }

    @Override
    public String toString() {
        return "HoodieGlobalRecordLocation {partitionPath=" + this.partitionPath + ", instantTime=" + this.instantTime + ", fileId=" + this.fileId + ", position=" + this.position + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieRecordGlobalLocation otherLoc = (HoodieRecordGlobalLocation)o;
        return Objects.equals(this.partitionPath, otherLoc.partitionPath) && Objects.equals(this.instantTime, otherLoc.instantTime) && Objects.equals(this.fileId, otherLoc.fileId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.partitionPath, this.instantTime, this.fileId);
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(String partitionPath) {
        this.partitionPath = partitionPath;
    }

    public static HoodieRecordGlobalLocation fromLocal(String partitionPath, HoodieRecordLocation localLoc) {
        return new HoodieRecordGlobalLocation(partitionPath, localLoc.getInstantTime(), localLoc.getFileId());
    }

    public HoodieRecordLocation toLocal(String instantTime) {
        return new HoodieRecordLocation(instantTime, this.fileId, this.position);
    }

    public HoodieRecordGlobalLocation copy(String partitionPath) {
        return new HoodieRecordGlobalLocation(partitionPath, this.instantTime, this.fileId, this.position);
    }

    @Override
    public void write(Kryo kryo, Output output) {
        super.write(kryo, output);
        kryo.writeObjectOrNull(output, (Object)this.partitionPath, String.class);
    }

    @Override
    public void read(Kryo kryo, Input input) {
        super.read(kryo, input);
        this.partitionPath = kryo.readObject(input, String.class);
    }
}

