/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.function.BooleanSupplier;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.file.DataFileWriter;
import org.apache.hudi.org.apache.avro.specific.SpecificDatumWriter;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.storage.HoodieInstantWriter;

public interface CommitMetadataSerDe
extends Serializable {
    public <T> T deserialize(HoodieInstant var1, InputStream var2, BooleanSupplier var3, Class<T> var4) throws IOException;

    public <T> Option<HoodieInstantWriter> getInstantWriter(T var1);

    public static <T extends SpecificRecordBase> Option<HoodieInstantWriter> getInstantWriter(Option<T> metadata) {
        if (metadata.isEmpty()) {
            return Option.empty();
        }
        return Option.of(outputStream -> {
            SpecificDatumWriter datumWriter = new SpecificDatumWriter(((SpecificRecordBase)metadata.get()).getClass());
            try (DataFileWriter fileWriter = new DataFileWriter(datumWriter);){
                fileWriter.create(((SpecificRecordBase)metadata.get()).getSchema(), outputStream);
                fileWriter.append(metadata.get());
            }
        });
    }
}

