/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineFactory;
import org.apache.hudi.common.table.timeline.dto.InstantDTO;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TimelineDTO {
    @JsonProperty(value="instants")
    List<InstantDTO> instants;

    public static TimelineDTO fromTimeline(HoodieTimeline timeline) {
        TimelineDTO dto = new TimelineDTO();
        dto.instants = timeline.getInstantsAsStream().map(InstantDTO::fromInstant).collect(Collectors.toList());
        return dto;
    }

    public static HoodieTimeline toTimeline(TimelineDTO dto, HoodieTableMetaClient metaClient) {
        InstantGenerator instantGenerator = metaClient.getInstantGenerator();
        TimelineFactory factory = metaClient.getTimelineLayout().getTimelineFactory();
        return factory.createDefaultTimeline(dto.instants.stream().map(d -> InstantDTO.toInstant(d, instantGenerator)), metaClient.getActiveTimeline());
    }
}

