/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.collection.FlatLists;
import org.apache.hudi.org.apache.avro.Schema;

public class SortUtils {
    static Object[] prependPartitionPath(String partitionPath, Object[] columnValues) {
        Object[] prependColumnValues = new Object[columnValues.length + 1];
        System.arraycopy(columnValues, 0, prependColumnValues, 1, columnValues.length);
        prependColumnValues[0] = partitionPath;
        return prependColumnValues;
    }

    static Object[] prependPartitionPathAndSuffixRecordKey(String partitionPath, String recordKey, Object[] columnValues) {
        Object[] newColumnValues = new Object[columnValues.length + 2];
        System.arraycopy(columnValues, 0, newColumnValues, 1, columnValues.length);
        newColumnValues[0] = partitionPath;
        newColumnValues[newColumnValues.length - 1] = recordKey;
        return newColumnValues;
    }

    public static FlatLists.ComparableList<Comparable<HoodieRecord>> getComparableSortColumns(HoodieRecord record, String[] sortColumnNames, Schema schema, boolean suffixRecordKey, boolean consistentLogicalTimestampEnabled) {
        if (record.getRecordType() == HoodieRecord.HoodieRecordType.SPARK) {
            Object[] columnValues = record.getColumnValues(schema, sortColumnNames, consistentLogicalTimestampEnabled);
            if (suffixRecordKey) {
                return FlatLists.ofComparableArray(SortUtils.prependPartitionPathAndSuffixRecordKey(record.getPartitionPath(), record.getRecordKey(), columnValues));
            }
            return FlatLists.ofComparableArray(SortUtils.prependPartitionPath(record.getPartitionPath(), columnValues));
        }
        if (record.getRecordType() == HoodieRecord.HoodieRecordType.AVRO) {
            return FlatLists.ofComparableArray(HoodieAvroUtils.getSortColumnValuesWithPartitionPathAndRecordKey(record, sortColumnNames, schema, suffixRecordKey, consistentLogicalTimestampEnabled));
        }
        throw new IllegalArgumentException("Invalid recordType" + (Object)((Object)record.getRecordType()));
    }
}

