/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.estimator;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hudi.common.data.HoodieAtomicLongAccumulator;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.estimator.RecordSizeEstimator;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AverageRecordSizeEstimator
extends RecordSizeEstimator {
    private static final Logger LOG = LoggerFactory.getLogger(AverageRecordSizeEstimator.class);
    private static final Set<String> RECORD_SIZE_ESTIMATE_ACTIONS = CollectionUtils.createSet("commit", "deltacommit", "compaction");

    public AverageRecordSizeEstimator(HoodieWriteConfig writeConfig) {
        super(writeConfig);
    }

    @Override
    public long averageBytesPerRecord(HoodieTimeline commitTimeline, CommitMetadataSerDe commitMetadataSerDe) {
        int maxCommits = this.hoodieWriteConfig.getRecordSizeEstimatorMaxCommits();
        AverageRecordSizeStats averageRecordSizeStats = new AverageRecordSizeStats(this.hoodieWriteConfig);
        try {
            if (!commitTimeline.empty()) {
                Stream<HoodieInstant> filteredInstants = commitTimeline.filterCompletedInstants().getReverseOrderedInstants().filter(s -> RECORD_SIZE_ESTIMATE_ACTIONS.contains(s.getAction())).limit(maxCommits);
                filteredInstants.forEach(instant -> {
                    try {
                        HoodieCommitMetadata commitMetadata = commitTimeline.readCommitMetadata((HoodieInstant)instant);
                        if (instant.getAction().equals("deltacommit")) {
                            ((Stream)commitMetadata.getWriteStats().stream().parallel()).filter(hoodieWriteStat -> FSUtils.isBaseFile(new StoragePath(hoodieWriteStat.getPath()))).forEach(hoodieWriteStat -> averageRecordSizeStats.updateStats(hoodieWriteStat.getTotalWriteBytes(), hoodieWriteStat.getNumWrites()));
                        } else {
                            averageRecordSizeStats.updateStats(commitMetadata.fetchTotalBytesWritten(), commitMetadata.fetchTotalRecordsWritten());
                        }
                    }
                    catch (IOException ignore) {
                        LOG.info("Failed to parse commit metadata", (Throwable)ignore);
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.warn("Got error while trying to compute average bytes/record but will proceed to use the computed value or fallback to default config value ", t);
        }
        return averageRecordSizeStats.computeAverageRecordSize();
    }

    private static class AverageRecordSizeStats
    implements Serializable {
        private final HoodieAtomicLongAccumulator totalBytesWritten = HoodieAtomicLongAccumulator.create();
        private final HoodieAtomicLongAccumulator totalRecordsWritten = HoodieAtomicLongAccumulator.create();
        private final long fileSizeThreshold;
        private final long avgMetadataSize;
        private final int defaultRecordSize;

        public AverageRecordSizeStats(HoodieWriteConfig hoodieWriteConfig) {
            this.fileSizeThreshold = (long)(hoodieWriteConfig.getRecordSizeEstimationThreshold() * (double)hoodieWriteConfig.getParquetSmallFileLimit());
            this.avgMetadataSize = hoodieWriteConfig.getRecordSizeEstimatorAverageMetadataSize();
            this.defaultRecordSize = hoodieWriteConfig.getCopyOnWriteRecordSizeEstimate();
        }

        private void updateStats(long fileSizeInBytes, long recordWritten) {
            if (fileSizeInBytes > this.fileSizeThreshold && fileSizeInBytes > this.avgMetadataSize && recordWritten > 0L) {
                this.totalBytesWritten.add(fileSizeInBytes - this.avgMetadataSize);
                this.totalRecordsWritten.add(recordWritten);
            }
        }

        private long computeAverageRecordSize() {
            if (this.totalBytesWritten.value() > 0L && this.totalRecordsWritten.value() > 0L) {
                return this.totalBytesWritten.value() / this.totalRecordsWritten.value();
            }
            return this.defaultRecordSize;
        }
    }
}

