/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.HoodieColumnProjectionUtils;
import org.apache.hudi.hadoop.SchemaEvolutionContext;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;
import org.apache.hudi.hadoop.utils.HiveAvroSerializer;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;
import org.apache.hudi.org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRealtimeRecordReader {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRealtimeRecordReader.class);
    protected final RealtimeSplit split;
    protected final JobConf jobConf;
    protected final boolean usesCustomPayload;
    protected TypedProperties payloadProps = new TypedProperties();
    private Schema readerSchema;
    private Schema writerSchema;
    private Schema hiveSchema;
    private final HoodieTableMetaClient metaClient;
    protected SchemaEvolutionContext schemaEvolutionContext;
    protected boolean supportPayload;
    protected HiveAvroSerializer serializer;
    private final boolean supportTimestamp;

    public AbstractRealtimeRecordReader(RealtimeSplit split, JobConf job) {
        this.split = split;
        this.jobConf = job;
        LOG.info("cfg ==> " + job.get("hive.io.file.readcolumn.names"));
        LOG.info("columnIds ==> " + job.get("hive.io.file.readcolumn.ids"));
        LOG.info("partitioningColumns ==> " + job.get("partition_columns", ""));
        this.supportPayload = Boolean.parseBoolean(job.get("hoodie.support.payload", "true"));
        try {
            this.metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.jobConf)).setBasePath(split.getBasePath()).build();
            this.payloadProps.putAll((Map<?, ?>)this.metaClient.getTableConfig().getProps(true));
            if (this.metaClient.getTableConfig().getPreCombineField() != null) {
                this.payloadProps.setProperty("hoodie.payload.ordering.field", this.metaClient.getTableConfig().getPreCombineField());
            }
            this.usesCustomPayload = this.usesCustomPayload(this.metaClient);
            LOG.info("usesCustomPayload ==> " + this.usesCustomPayload);
            this.supportTimestamp = HoodieColumnProjectionUtils.supportTimestamp((Configuration)this.jobConf);
            this.schemaEvolutionContext = new SchemaEvolutionContext((InputSplit)split, job, Option.of(this.metaClient));
            if (this.schemaEvolutionContext.internalSchemaOption.isPresent()) {
                this.schemaEvolutionContext.doEvolutionForRealtimeInputFormat(this);
            } else {
                this.init();
            }
        }
        catch (Exception e) {
            throw new HoodieException("Could not create HoodieRealtimeRecordReader on path " + this.split.getPath(), e);
        }
        this.prepareHiveAvroSerializer();
    }

    private boolean usesCustomPayload(HoodieTableMetaClient metaClient) {
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        if (tableConfig.contains(HoodieTableConfig.RECORD_MERGE_MODE) && tableConfig.contains(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID)) {
            return tableConfig.getRecordMergeMode().equals((Object)RecordMergeMode.CUSTOM) && tableConfig.getRecordMergeStrategyId().equals("00000000-0000-0000-0000-000000000000");
        }
        return false;
    }

    private void prepareHiveAvroSerializer() {
        try {
            int columnNameListLen;
            String lastColName;
            Set writerSchemaColNames = this.writerSchema.getFields().stream().map(f -> f.name().toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            List<String> columnNameList = Arrays.stream(this.jobConf.get("columns").split(",")).collect(Collectors.toList());
            ArrayList columnTypeList = TypeInfoUtils.getTypeInfosFromTypeString((String)this.jobConf.get("columns.types"));
            for (int i = columnNameListLen = columnNameList.size() - 1; i >= 0 && !writerSchemaColNames.contains(lastColName = (String)columnNameList.get(columnNameList.size() - 1)); --i) {
                LOG.debug(String.format("remove virtual column: %s", lastColName));
                columnNameList.remove(columnNameList.size() - 1);
                columnTypeList.remove(columnTypeList.size() - 1);
            }
            StructTypeInfo rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(columnNameList, (List)columnTypeList);
            this.serializer = new HiveAvroSerializer((ObjectInspector)new ArrayWritableObjectInspector(rowTypeInfo), columnNameList, columnTypeList);
        }
        catch (Exception e) {
            LOG.warn("fall to init HiveAvroSerializer to support payload merge", (Throwable)e);
            this.supportPayload = false;
        }
    }

    private void init() throws Exception {
        LOG.info("Getting writer schema from table avro schema ");
        this.writerSchema = new TableSchemaResolver(this.metaClient).getTableAvroSchema();
        String partitionFields = this.jobConf.get("partition_columns", "");
        ArrayList<String> partitioningFields = partitionFields.length() > 0 ? Arrays.stream(partitionFields.split("/")).collect(Collectors.toList()) : new ArrayList<String>();
        this.writerSchema = HoodieRealtimeRecordReaderUtils.addPartitionFields(this.writerSchema, partitioningFields);
        List<String> projectionFields = HoodieRealtimeRecordReaderUtils.orderFields(this.jobConf.get("hive.io.file.readcolumn.names", ""), this.jobConf.get("hive.io.file.readcolumn.ids", ""), partitioningFields);
        Map<String, Schema.Field> schemaFieldsMap = HoodieRealtimeRecordReaderUtils.getNameToFieldMap(this.writerSchema);
        this.hiveSchema = this.constructHiveOrderedSchema(this.writerSchema, schemaFieldsMap, this.jobConf.get("columns", ""));
        this.readerSchema = HoodieRealtimeRecordReaderUtils.generateProjectionSchema(this.writerSchema, schemaFieldsMap, projectionFields);
        LOG.info(String.format("About to read compacted logs %s for base split %s, projecting cols %s", this.split.getDeltaLogPaths(), this.split.getPath(), projectionFields));
    }

    public Schema constructHiveOrderedSchema(Schema writerSchema, Map<String, Schema.Field> schemaFieldsMap, String hiveColumnString) {
        String[] hiveColumns = hiveColumnString.isEmpty() ? new String[]{} : hiveColumnString.split(",");
        LOG.info("Hive Columns : " + hiveColumnString);
        ArrayList<Schema.Field> hiveSchemaFields = new ArrayList<Schema.Field>();
        for (String columnName : hiveColumns) {
            Schema.Field field = schemaFieldsMap.get(columnName.toLowerCase());
            if (field != null) {
                hiveSchemaFields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal()));
                continue;
            }
            LOG.debug("Skipping Hive Column => " + columnName);
        }
        Schema hiveSchema = Schema.createRecord(writerSchema.getName(), writerSchema.getDoc(), writerSchema.getNamespace(), writerSchema.isError());
        hiveSchema.setFields(hiveSchemaFields);
        LOG.debug("HIVE Schema is :" + hiveSchema.toString(true));
        return hiveSchema;
    }

    protected Schema getLogScannerReaderSchema() {
        return this.usesCustomPayload ? this.writerSchema : this.readerSchema;
    }

    public Schema getReaderSchema() {
        return this.readerSchema;
    }

    public Schema getWriterSchema() {
        return this.writerSchema;
    }

    public Schema getHiveSchema() {
        return this.hiveSchema;
    }

    public boolean isSupportTimestamp() {
        return this.supportTimestamp;
    }

    public RealtimeSplit getSplit() {
        return this.split;
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }

    public void setReaderSchema(Schema readerSchema) {
        this.readerSchema = readerSchema;
    }

    public void setWriterSchema(Schema writerSchema) {
        this.writerSchema = writerSchema;
    }

    public void setHiveSchema(Schema hiveSchema) {
        this.hiveSchema = hiveSchema;
    }
}

