/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.IOContextMap;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.HoodieFileGroupReaderBasedRecordReader;
import org.apache.hudi.hadoop.hive.HoodieCombineRealtimeFileSplit;
import org.apache.hudi.hadoop.realtime.AbstractRealtimeRecordReader;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeRecordReader;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieCombineRealtimeRecordReader
implements RecordReader<NullWritable, ArrayWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieCombineRealtimeRecordReader.class);
    private final List<RecordReader> recordReaders = new LinkedList<RecordReader>();
    private RecordReader currentRecordReader;
    private final boolean useFileGroupReader;

    public HoodieCombineRealtimeRecordReader(JobConf jobConf, CombineFileSplit split, List<RecordReader> readers) {
        try {
            this.useFileGroupReader = HoodieInputFormatUtils.shouldUseFilegroupReader(jobConf, (InputSplit)split);
            ValidationUtils.checkArgument(((HoodieCombineRealtimeFileSplit)split).getRealtimeFileSplits().size() == readers.size(), "Num Splits does not match number of unique RecordReaders!");
            for (InputSplit inputSplit : ((HoodieCombineRealtimeFileSplit)split).getRealtimeFileSplits()) {
                if (this.useFileGroupReader) {
                    LOG.info("Creating new HoodieFileGroupReaderRecordReader for split");
                    RecordReader reader = readers.remove(0);
                    ValidationUtils.checkArgument(reader instanceof HoodieFileGroupReaderBasedRecordReader, reader.toString() + "not instance of HoodieFileGroupReaderRecordReader ");
                    this.recordReaders.add(reader);
                    continue;
                }
                LOG.info("Creating new RealtimeRecordReader for split");
                this.recordReaders.add(new HoodieRealtimeRecordReader((HoodieRealtimeFileSplit)inputSplit, jobConf, (RecordReader<NullWritable, ArrayWritable>)readers.remove(0)));
            }
            this.currentRecordReader = this.recordReaders.remove(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean next(NullWritable key, ArrayWritable value) throws IOException {
        if (this.currentRecordReader.next((Object)key, (Object)value)) {
            return true;
        }
        if (this.recordReaders.size() > 0) {
            Path path;
            JobConf jobConf;
            this.currentRecordReader.close();
            this.currentRecordReader = this.recordReaders.remove(0);
            if (this.useFileGroupReader) {
                RecordReader reader = this.currentRecordReader;
                jobConf = ((HoodieFileGroupReaderBasedRecordReader)reader).getJobConf();
                path = ((HoodieFileGroupReaderBasedRecordReader)reader).getSplit().getPath();
            } else {
                RecordReader<NullWritable, ArrayWritable> reader = ((HoodieRealtimeRecordReader)this.currentRecordReader).getReader();
                jobConf = ((AbstractRealtimeRecordReader)reader).getJobConf();
                path = ((AbstractRealtimeRecordReader)reader).getSplit().getPath();
            }
            IOContextMap.get((Configuration)jobConf).setInputPath(path);
            return this.next(key, value);
        }
        return false;
    }

    public NullWritable createKey() {
        if (this.useFileGroupReader) {
            return ((HoodieFileGroupReaderBasedRecordReader)this.currentRecordReader).createKey();
        }
        return ((HoodieRealtimeRecordReader)this.currentRecordReader).createKey();
    }

    public ArrayWritable createValue() {
        if (this.useFileGroupReader) {
            return ((HoodieFileGroupReaderBasedRecordReader)this.currentRecordReader).createValue();
        }
        return ((HoodieRealtimeRecordReader)this.currentRecordReader).createValue();
    }

    public long getPos() throws IOException {
        return this.currentRecordReader.getPos();
    }

    public void close() throws IOException {
        this.currentRecordReader.close();
    }

    public float getProgress() throws IOException {
        return this.currentRecordReader.getProgress();
    }
}

