/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieIOHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.table.HoodieTable;

public abstract class HoodieReadHandle<T, I, K, O>
extends HoodieIOHandle<T, I, K, O> {
    protected final Pair<String, String> partitionPathFileIDPair;

    public HoodieReadHandle(HoodieWriteConfig config, HoodieTable<T, I, K, O> hoodieTable, Pair<String, String> partitionPathFileIDPair) {
        super(config, Option.empty(), hoodieTable);
        this.partitionPathFileIDPair = partitionPathFileIDPair;
    }

    public HoodieReadHandle(HoodieWriteConfig config, Option<String> instantTime, HoodieTable<T, I, K, O> hoodieTable, Pair<String, String> partitionPathFileIDPair) {
        super(config, instantTime, hoodieTable);
        this.partitionPathFileIDPair = partitionPathFileIDPair;
    }

    @Override
    public HoodieStorage getStorage() {
        return this.hoodieTable.getStorage();
    }

    public Pair<String, String> getPartitionPathFileIDPair() {
        return this.partitionPathFileIDPair;
    }

    public String getFileId() {
        return this.partitionPathFileIDPair.getRight();
    }

    protected HoodieBaseFile getLatestBaseFile() {
        return this.hoodieTable.getBaseFileOnlyView().getLatestBaseFile(this.partitionPathFileIDPair.getLeft(), this.partitionPathFileIDPair.getRight()).get();
    }

    protected HoodieFileReader createNewFileReader() throws IOException {
        return HoodieIOFactory.getIOFactory(this.hoodieTable.getStorage()).getReaderFactory(this.config.getRecordMerger().getRecordType()).getFileReader(this.config, this.getLatestBaseFile().getStoragePath());
    }

    protected HoodieFileReader createNewFileReader(HoodieBaseFile hoodieBaseFile) throws IOException {
        return HoodieIOFactory.getIOFactory(this.hoodieTable.getStorage()).getReaderFactory(this.config.getRecordMerger().getRecordType()).getFileReader(this.config, hoodieBaseFile.getStoragePath());
    }
}

