/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hadoop;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.hadoop.HoodieHFileUtils;
import org.apache.hudi.io.storage.HoodieAvroHFileReaderImplBase;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.util.Lazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieHBaseAvroHFileReader
extends HoodieAvroHFileReaderImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieHBaseAvroHFileReader.class);
    private final StoragePath path;
    private final HoodieStorage storage;
    private final StorageConfiguration<?> storageConf;
    private final CacheConfig config;
    private final Option<byte[]> content;
    private final Lazy<Schema> schema;
    private Option<HFile.Reader> sharedReader;
    private Option<HFileScanner> sharedScanner;
    private final Object sharedLock = new Object();

    public HoodieHBaseAvroHFileReader(StorageConfiguration<?> storageConf, StoragePath path, Option<Schema> schemaOpt) throws IOException {
        this(path, new HoodieHadoopStorage(path, storageConf), storageConf, schemaOpt, Option.empty());
    }

    public HoodieHBaseAvroHFileReader(StorageConfiguration<?> storageConf, StoragePath path, HoodieStorage storage, byte[] content, Option<Schema> schemaOpt) throws IOException {
        this(path, storage, storageConf, schemaOpt, Option.of(content));
    }

    public HoodieHBaseAvroHFileReader(StorageConfiguration<?> storageConf, StoragePath path) throws IOException {
        this(storageConf, path, Option.empty());
    }

    public HoodieHBaseAvroHFileReader(StoragePath path, HoodieStorage storage, StorageConfiguration<?> storageConf, Option<Schema> schemaOpt, Option<byte[]> content) throws IOException {
        this.path = path;
        this.storage = storage;
        this.storageConf = storageConf;
        this.config = new CacheConfig(storageConf.unwrapAs(Configuration.class));
        this.content = content;
        this.sharedReader = Option.empty();
        this.sharedScanner = Option.empty();
        this.schema = schemaOpt.map(Lazy::eagerly).orElseGet(() -> Lazy.lazily(() -> HoodieHBaseAvroHFileReader.fetchSchema(this.getSharedHFileReader())));
    }

    @Override
    public ClosableIterator<HoodieRecord<IndexedRecord>> getRecordsByKeysIterator(List<String> sortedKeys, Schema schema) throws IOException {
        HFile.Reader reader = this.getHFileReader();
        HFileScanner scanner = HoodieHBaseAvroHFileReader.getHFileScanner(reader, true);
        RecordByKeyIterator iterator2 = new RecordByKeyIterator(reader, scanner, sortedKeys, this.getSchema(), schema);
        return new CloseableMappingIterator<IndexedRecord, HoodieRecord>(iterator2, data -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data)));
    }

    @Override
    public ClosableIterator<HoodieRecord<IndexedRecord>> getRecordsByKeyPrefixIterator(List<String> sortedKeyPrefixes, Schema schema) throws IOException {
        ClosableIterator<IndexedRecord> iterator2 = this.getIndexedRecordsByKeyPrefixIterator(sortedKeyPrefixes, schema);
        return new CloseableMappingIterator<IndexedRecord, HoodieRecord>(iterator2, data -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data)));
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        HFileInfo fileInfo = this.getSharedHFileReader().getHFileInfo();
        return new String[]{new String(fileInfo.get(StringUtils.getUTF8Bytes("minRecordKey"))), new String(fileInfo.get(StringUtils.getUTF8Bytes("maxRecordKey")))};
    }

    @Override
    public BloomFilter readBloomFilter() {
        try {
            HFileInfo fileInfo = this.getSharedHFileReader().getHFileInfo();
            ByteBuff buf = this.getSharedHFileReader().getMetaBlock("bloomFilter", false).getBufferWithoutHeader();
            byte[] bytes = new byte[buf.remaining()];
            buf.get(bytes);
            return BloomFilterFactory.fromString(new String(bytes), new String(fileInfo.get(StringUtils.getUTF8Bytes("bloomFilterTypeCode"))));
        }
        catch (IOException e) {
            throw new HoodieException("Could not read bloom filter from " + this.path, e);
        }
    }

    @Override
    public Schema getSchema() {
        return this.schema.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Pair<String, Long>> filterRowKeys(Set<String> candidateRowKeys) {
        TreeSet<String> sortedCandidateRowKeys = new TreeSet<String>(candidateRowKeys);
        Object object = this.sharedLock;
        synchronized (object) {
            if (!this.sharedScanner.isPresent()) {
                this.sharedScanner = Option.of(HoodieHBaseAvroHFileReader.getHFileScanner(this.getSharedHFileReader(), true));
            }
            return sortedCandidateRowKeys.stream().filter(k -> {
                try {
                    return this.isKeyAvailable((String)k, this.sharedScanner.get());
                }
                catch (IOException e) {
                    LOG.error("Failed to check key availability: " + k);
                    return false;
                }
            }).map(key -> Pair.of(key, -1L)).collect(Collectors.toSet());
        }
    }

    @Override
    public ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema readerSchema, Schema requestedSchema) {
        if (!Objects.equals(readerSchema, requestedSchema)) {
            throw new UnsupportedOperationException("Schema projections are not supported in HFile reader");
        }
        HFile.Reader reader = this.getHFileReader();
        HFileScanner scanner = HoodieHBaseAvroHFileReader.getHFileScanner(reader, false, false);
        return new RecordIterator(reader, scanner, this.getSchema(), readerSchema);
    }

    @Override
    @VisibleForTesting
    public ClosableIterator<IndexedRecord> getIndexedRecordsByKeysIterator(List<String> keys2, Schema readerSchema) throws IOException {
        HFile.Reader reader = this.getHFileReader();
        HFileScanner scanner = HoodieHBaseAvroHFileReader.getHFileScanner(reader, true);
        return new RecordByKeyIterator(reader, scanner, keys2, this.getSchema(), readerSchema);
    }

    @Override
    @VisibleForTesting
    public ClosableIterator<IndexedRecord> getIndexedRecordsByKeyPrefixIterator(List<String> sortedKeyPrefixes, Schema readerSchema) throws IOException {
        HFile.Reader reader = this.getHFileReader();
        HFileScanner scanner = HoodieHBaseAvroHFileReader.getHFileScanner(reader, true);
        return new RecordByKeyPrefixIterator(reader, scanner, sortedKeyPrefixes, this.getSchema(), readerSchema);
    }

    @Override
    public long getTotalRecords() {
        return this.getSharedHFileReader().getEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            HoodieHBaseAvroHFileReader hoodieHBaseAvroHFileReader = this;
            synchronized (hoodieHBaseAvroHFileReader) {
                if (this.sharedScanner.isPresent()) {
                    this.sharedScanner.get().close();
                }
                if (this.sharedReader.isPresent()) {
                    this.sharedReader.get().close();
                }
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Error closing the hfile reader", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HFile.Reader getSharedHFileReader() {
        if (!this.sharedReader.isPresent()) {
            Object object = this.sharedLock;
            synchronized (object) {
                if (!this.sharedReader.isPresent()) {
                    this.sharedReader = Option.of(this.getHFileReader());
                }
            }
        }
        return this.sharedReader.get();
    }

    private HFile.Reader getHFileReader() {
        if (this.content.isPresent()) {
            return HoodieHFileUtils.createHFileReader(this.storage, this.path, this.content.get());
        }
        return HoodieHFileUtils.createHFileReader(this.storage, this.path, this.config, this.storageConf.unwrapAs(Configuration.class));
    }

    private boolean isKeyAvailable(String key, HFileScanner keyScanner) throws IOException {
        KeyValue kv = new KeyValue(StringUtils.getUTF8Bytes(key), null, null, null);
        return keyScanner.seekTo(kv) == 0;
    }

    private static Iterator<IndexedRecord> getRecordByKeyPrefixIteratorInternal(final HFileScanner scanner, final String keyPrefix, final Schema writerSchema, final Schema readerSchema) throws IOException {
        KeyValue kv = new KeyValue(StringUtils.getUTF8Bytes(keyPrefix), null, null, null);
        int val = scanner.reseekTo(kv);
        if (val == 1 && !scanner.next()) {
            return Collections.emptyIterator();
        }
        class KeyPrefixIterator
        implements Iterator<IndexedRecord> {
            private IndexedRecord next = null;
            private boolean eof = false;

            KeyPrefixIterator() {
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                if (this.eof) {
                    return false;
                }
                Cell c = Objects.requireNonNull(scanner.getCell());
                byte[] keyBytes = HoodieHBaseAvroHFileReader.copyKeyFromCell(c);
                String key = new String(keyBytes);
                if (!key.startsWith(keyPrefix)) {
                    return false;
                }
                byte[] valueBytes = HoodieHBaseAvroHFileReader.copyValueFromCell(c);
                try {
                    this.next = HoodieHBaseAvroHFileReader.deserialize(keyBytes, valueBytes, writerSchema, readerSchema);
                    this.eof = !scanner.next();
                }
                catch (IOException e) {
                    throw new HoodieIOException("Failed to deserialize payload", e);
                }
                return true;
            }

            @Override
            public IndexedRecord next() {
                IndexedRecord next = this.next;
                this.next = null;
                return next;
            }
        }
        return new KeyPrefixIterator();
    }

    private static Option<IndexedRecord> fetchRecordByKeyInternal(HFileScanner scanner, String key, Schema writerSchema, Schema readerSchema) throws IOException {
        byte[] keyBytes = StringUtils.getUTF8Bytes(key);
        KeyValue kv = new KeyValue(keyBytes, null, null, null);
        if (scanner.reseekTo(kv) != 0) {
            return Option.empty();
        }
        Cell c = scanner.getCell();
        byte[] valueBytes = HoodieHBaseAvroHFileReader.copyValueFromCell(c);
        GenericRecord record = HoodieHBaseAvroHFileReader.deserialize(keyBytes, valueBytes, writerSchema, readerSchema);
        return Option.of(record);
    }

    private static GenericRecord getRecordFromCell(Cell cell, Schema writerSchema, Schema readerSchema) throws IOException {
        byte[] keyBytes = HoodieHBaseAvroHFileReader.copyKeyFromCell(cell);
        byte[] valueBytes = HoodieHBaseAvroHFileReader.copyValueFromCell(cell);
        return HoodieHBaseAvroHFileReader.deserialize(keyBytes, 0, keyBytes.length, valueBytes, 0, valueBytes.length, writerSchema, readerSchema);
    }

    private static Schema fetchSchema(HFile.Reader reader) {
        HFileInfo fileInfo = reader.getHFileInfo();
        return new Schema.Parser().parse(new String(fileInfo.get(StringUtils.getUTF8Bytes("schema"))));
    }

    private static byte[] copyKeyFromCell(Cell cell) {
        return Arrays.copyOfRange(cell.getRowArray(), cell.getRowOffset(), cell.getRowOffset() + cell.getRowLength());
    }

    private static byte[] copyValueFromCell(Cell c) {
        return Arrays.copyOfRange(c.getValueArray(), c.getValueOffset(), c.getValueOffset() + c.getValueLength());
    }

    private static HFileScanner getHFileScanner(HFile.Reader reader, boolean cacheBlocks) {
        return HoodieHBaseAvroHFileReader.getHFileScanner(reader, cacheBlocks, true);
    }

    private static HFileScanner getHFileScanner(HFile.Reader reader, boolean cacheBlocks, boolean doSeek) {
        try {
            HFileScanner scanner = reader.getScanner(cacheBlocks, true);
            if (doSeek) {
                scanner.seekTo();
            }
            return scanner;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to initialize HFile scanner for  " + reader.getPath(), e);
        }
    }

    @Override
    public ClosableIterator<String> getRecordKeyIterator() {
        final HFile.Reader reader = this.getHFileReader();
        final HFileScanner scanner = reader.getScanner(false, false);
        return new ClosableIterator<String>(){

            @Override
            public boolean hasNext() {
                try {
                    return scanner.next();
                }
                catch (IOException e) {
                    throw new HoodieException("Error while scanning for keys", e);
                }
            }

            @Override
            public String next() {
                Cell cell = scanner.getCell();
                byte[] keyBytes = HoodieHBaseAvroHFileReader.copyKeyFromCell(cell);
                return new String(keyBytes);
            }

            @Override
            public void close() {
                try {
                    scanner.close();
                    reader.close();
                }
                catch (IOException e) {
                    throw new HoodieIOException("Error closing the hfile reader and scanner", e);
                }
            }
        };
    }

    private static class RecordIterator
    implements ClosableIterator<IndexedRecord> {
        private final HFile.Reader reader;
        private final HFileScanner scanner;
        private final Schema writerSchema;
        private final Schema readerSchema;
        private IndexedRecord next = null;
        private boolean eof = false;

        RecordIterator(HFile.Reader reader, HFileScanner scanner, Schema writerSchema, Schema readerSchema) {
            this.reader = reader;
            this.scanner = scanner;
            this.writerSchema = writerSchema;
            this.readerSchema = readerSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.eof) {
                    return false;
                }
                if (this.next != null) {
                    return true;
                }
                boolean hasRecords = !this.scanner.isSeeked() ? this.scanner.seekTo() : this.scanner.next();
                if (!hasRecords) {
                    this.eof = true;
                    return false;
                }
                this.next = HoodieHBaseAvroHFileReader.getRecordFromCell(this.scanner.getCell(), this.writerSchema, this.readerSchema);
                return true;
            }
            catch (IOException io) {
                throw new HoodieIOException("unable to read next record from hfile ", io);
            }
        }

        @Override
        public IndexedRecord next() {
            IndexedRecord next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            try {
                this.scanner.close();
                this.reader.close();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error closing the hfile reader and scanner", e);
            }
        }
    }

    private static class RecordByKeyIterator
    implements ClosableIterator<IndexedRecord> {
        private final Iterator<String> sortedKeyIterator;
        private final HFile.Reader reader;
        private final HFileScanner scanner;
        private final Schema readerSchema;
        private final Schema writerSchema;
        private IndexedRecord next = null;

        RecordByKeyIterator(HFile.Reader reader, HFileScanner scanner, List<String> sortedKeys, Schema writerSchema, Schema readerSchema) throws IOException {
            this.sortedKeyIterator = sortedKeys.iterator();
            this.reader = reader;
            this.scanner = scanner;
            this.scanner.seekTo();
            this.writerSchema = writerSchema;
            this.readerSchema = readerSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.next != null) {
                    return true;
                }
                while (this.sortedKeyIterator.hasNext()) {
                    Option value = HoodieHBaseAvroHFileReader.fetchRecordByKeyInternal(this.scanner, this.sortedKeyIterator.next(), this.writerSchema, this.readerSchema);
                    if (!value.isPresent()) continue;
                    this.next = (IndexedRecord)value.get();
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new HoodieIOException("unable to read next record from hfile ", e);
            }
        }

        @Override
        public IndexedRecord next() {
            IndexedRecord next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            try {
                this.scanner.close();
                this.reader.close();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error closing the hfile reader and scanner", e);
            }
        }
    }

    private static class RecordByKeyPrefixIterator
    implements ClosableIterator<IndexedRecord> {
        private final Iterator<String> sortedKeyPrefixesIterator;
        private Iterator<IndexedRecord> recordsIterator;
        private final HFile.Reader reader;
        private final HFileScanner scanner;
        private final Schema writerSchema;
        private final Schema readerSchema;
        private IndexedRecord next = null;

        RecordByKeyPrefixIterator(HFile.Reader reader, HFileScanner scanner, List<String> sortedKeyPrefixes, Schema writerSchema, Schema readerSchema) throws IOException {
            this.sortedKeyPrefixesIterator = sortedKeyPrefixes.iterator();
            this.reader = reader;
            this.scanner = scanner;
            this.scanner.seekTo();
            this.writerSchema = writerSchema;
            this.readerSchema = readerSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                while (true) {
                    if (this.next != null) {
                        return true;
                    }
                    if (this.recordsIterator != null && this.recordsIterator.hasNext()) {
                        this.next = this.recordsIterator.next();
                        return true;
                    }
                    if (!this.sortedKeyPrefixesIterator.hasNext()) break;
                    String currentKeyPrefix = this.sortedKeyPrefixesIterator.next();
                    this.recordsIterator = HoodieHBaseAvroHFileReader.getRecordByKeyPrefixIteratorInternal(this.scanner, currentKeyPrefix, this.writerSchema, this.readerSchema);
                }
                return false;
            }
            catch (IOException e) {
                throw new HoodieIOException("Unable to read next record from HFile", e);
            }
        }

        @Override
        public IndexedRecord next() {
            IndexedRecord next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            try {
                this.scanner.close();
                this.reader.close();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error closing the hfile reader and scanner", e);
            }
        }
    }
}

