/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.org.apache.avro.Schema;

public abstract class HoodieBootstrapRecordIterator<T>
implements ClosableIterator<HoodieRecord<T>> {
    protected ClosableIterator<HoodieRecord<T>> skeletonIterator;
    protected ClosableIterator<HoodieRecord<T>> dataFileIterator;
    private final Option<String[]> partitionFields;
    private final Object[] partitionValues;
    protected Schema schema;

    public HoodieBootstrapRecordIterator(ClosableIterator<HoodieRecord<T>> skeletonIterator, ClosableIterator<HoodieRecord<T>> dataFileIterator, Schema schema, Option<String[]> partitionFields, Object[] partitionValues) {
        this.skeletonIterator = skeletonIterator;
        this.dataFileIterator = dataFileIterator;
        this.schema = schema;
        this.partitionFields = partitionFields;
        this.partitionValues = partitionValues;
    }

    @Override
    public void close() {
        this.skeletonIterator.close();
        this.dataFileIterator.close();
    }

    @Override
    public boolean hasNext() {
        ValidationUtils.checkState(this.skeletonIterator.hasNext() == this.dataFileIterator.hasNext());
        return this.skeletonIterator.hasNext();
    }

    @Override
    public HoodieRecord<T> next() {
        HoodieRecord dataRecord = (HoodieRecord)this.dataFileIterator.next();
        HoodieRecord skeletonRecord = (HoodieRecord)this.skeletonIterator.next();
        HoodieRecord ret = dataRecord.prependMetaFields(this.schema, this.schema, new MetadataValues().setCommitTime(skeletonRecord.getRecordKey(this.schema, HoodieRecord.COMMIT_TIME_METADATA_FIELD)).setCommitSeqno(skeletonRecord.getRecordKey(this.schema, HoodieRecord.COMMIT_SEQNO_METADATA_FIELD)).setRecordKey(skeletonRecord.getRecordKey(this.schema, HoodieRecord.RECORD_KEY_METADATA_FIELD)).setPartitionPath(skeletonRecord.getRecordKey(this.schema, HoodieRecord.PARTITION_PATH_METADATA_FIELD)).setFileName(skeletonRecord.getRecordKey(this.schema, HoodieRecord.FILENAME_METADATA_FIELD)), null);
        if (this.partitionFields.isPresent()) {
            for (int i = 0; i < this.partitionValues.length; ++i) {
                int position = this.schema.getField(this.partitionFields.get()[i]).pos();
                this.setPartitionPathField(position, this.partitionValues[i], ret.getData());
            }
        }
        return ret;
    }

    protected abstract void setPartitionPathField(int var1, Object var2, T var3);
}

