/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.avro.HoodieBloomFilterWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.io.storage.row.RowDataParquetWriteSupport;
import org.apache.parquet.hadoop.api.WriteSupport;

public class HoodieRowDataParquetWriteSupport
extends RowDataParquetWriteSupport {
    private final Configuration hadoopConf;
    private final Option<HoodieBloomFilterWriteSupport<String>> bloomFilterWriteSupportOpt;

    public HoodieRowDataParquetWriteSupport(Configuration conf, RowType rowType, BloomFilter bloomFilter) {
        super(rowType);
        this.hadoopConf = new Configuration(conf);
        this.bloomFilterWriteSupportOpt = Option.ofNullable(bloomFilter).map(HoodieBloomFilterRowDataWriteSupport::new);
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    @Override
    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        Map<String, String> extraMetadata = this.bloomFilterWriteSupportOpt.map(HoodieBloomFilterWriteSupport::finalizeMetadata).orElse(Collections.emptyMap());
        return new WriteSupport.FinalizedWriteContext(extraMetadata);
    }

    public void add(String recordKey) {
        this.bloomFilterWriteSupportOpt.ifPresent(bloomFilterWriteSupport -> bloomFilterWriteSupport.addKey(recordKey));
    }

    private static class HoodieBloomFilterRowDataWriteSupport
    extends HoodieBloomFilterWriteSupport<String> {
        public HoodieBloomFilterRowDataWriteSupport(BloomFilter bloomFilter) {
            super(bloomFilter);
        }

        @Override
        protected byte[] getUTF8Bytes(String key) {
            return StringUtils.getUTF8Bytes(key);
        }
    }
}

