/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.expression.ArrayData;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;

public abstract class AbstractHoodieTableMetadata
implements HoodieTableMetadata {
    protected transient HoodieEngineContext engineContext;
    protected transient HoodieStorage storage;
    protected final StorageConfiguration<?> storageConf;
    protected final StoragePath dataBasePath;
    protected final boolean caseSensitive = false;

    public AbstractHoodieTableMetadata(HoodieEngineContext engineContext, HoodieStorage storage, String dataBasePath) {
        this.engineContext = engineContext;
        this.storage = storage;
        this.storageConf = storage.getConf();
        this.dataBasePath = new StoragePath(dataBasePath);
    }

    protected static int getPathPartitionLevel(Types.RecordType partitionFields, String path) {
        if (StringUtils.isNullOrEmpty(path) || partitionFields == null) {
            return 0;
        }
        int level = 1;
        for (int i = 1; i < path.length() - 1; ++i) {
            if (path.charAt(i) != '/') continue;
            ++level;
        }
        if (path.startsWith("/")) {
            --level;
        }
        if (path.endsWith("/")) {
            --level;
        }
        return level;
    }

    protected static ArrayData extractPartitionValues(Types.RecordType partitionFields, String relativePartitionPath, boolean urlEncodePartitioningEnabled) {
        if (partitionFields.fields().size() == 1) {
            String partitionValue = relativePartitionPath.split("=")[1];
            return new ArrayData(Collections.singletonList(Type.fromPartitionString(urlEncodePartitioningEnabled ? PartitionPathEncodeUtils.unescapePathName(partitionValue) : partitionValue, partitionFields.field(0).type())));
        }
        String[] partitionFragments = relativePartitionPath.split("/");
        List<Object> partitionValues = IntStream.range(0, partitionFragments.length).mapToObj(idx -> {
            String partitionValue = partitionFragments[idx].split("=")[1];
            return Type.fromPartitionString(urlEncodePartitioningEnabled ? PartitionPathEncodeUtils.unescapePathName(partitionValue) : partitionValue, partitionFields.field(idx).type());
        }).collect(Collectors.toList());
        return new ArrayData(partitionValues);
    }
}

