/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hudi.javax.servlet.ServletException;
import org.apache.hudi.javax.servlet.http.HttpServlet;
import org.apache.hudi.javax.servlet.http.HttpServletRequest;
import org.apache.hudi.javax.servlet.http.HttpServletResponse;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hudi.org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RSStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HRegionServer hrs = (HRegionServer)this.getServletContext().getAttribute("regionserver");
        assert (hrs != null) : "No RS in context!";
        resp.setContentType("text/html");
        if (!hrs.isOnline()) {
            resp.getWriter().write("The RegionServer is initializing!");
            resp.getWriter().close();
            return;
        }
        RSStatusTmpl tmpl = new RSStatusTmpl();
        if (req.getParameter("format") != null) {
            tmpl.setFormat(req.getParameter("format"));
        }
        if (req.getParameter("filter") != null) {
            tmpl.setFilter(req.getParameter("filter"));
        }
        if (req.getParameter("bcn") != null) {
            tmpl.setBcn(req.getParameter("bcn"));
        }
        if (req.getParameter("bcv") != null) {
            tmpl.setBcv(req.getParameter("bcv"));
        }
        tmpl.render(resp.getWriter(), hrs);
    }
}

