/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.schema;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.schema.SchemaProvider;

public class FilebasedSchemaProvider
extends SchemaProvider {
    private final Schema sourceSchema;
    private Schema targetSchema;

    @Deprecated
    public FilebasedSchemaProvider(TypedProperties props) {
        ConfigUtils.checkRequiredConfigProperties(props, Collections.singletonList(Config.SOURCE_SCHEMA_FILE));
        String sourceSchemaFile = ConfigUtils.getStringWithAltKeys(props, Config.SOURCE_SCHEMA_FILE);
        FileSystem fs = HadoopFSUtils.getFs(sourceSchemaFile, HadoopConfigurations.getHadoopConf(new Configuration()));
        try {
            this.sourceSchema = new Schema.Parser().parse((InputStream)fs.open(new Path(sourceSchemaFile)));
            if (ConfigUtils.containsConfigProperty(props, Config.TARGET_SCHEMA_FILE)) {
                this.targetSchema = new Schema.Parser().parse((InputStream)fs.open(new Path(ConfigUtils.getStringWithAltKeys(props, Config.TARGET_SCHEMA_FILE))));
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error reading schema", ioe);
        }
    }

    public FilebasedSchemaProvider(Configuration conf) {
        String sourceSchemaPath = conf.getString(FlinkOptions.SOURCE_AVRO_SCHEMA_PATH);
        FileSystem fs = HadoopFSUtils.getFs(sourceSchemaPath, HadoopConfigurations.getHadoopConf(conf));
        try {
            this.sourceSchema = new Schema.Parser().parse((InputStream)fs.open(new Path(sourceSchemaPath)));
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error reading schema", ioe);
        }
    }

    @Override
    public Schema getSourceSchema() {
        return this.sourceSchema;
    }

    @Override
    public Schema getTargetSchema() {
        if (this.targetSchema != null) {
            return this.targetSchema;
        }
        return super.getTargetSchema();
    }

    public static class Config {
        private static final ConfigProperty<String> SOURCE_SCHEMA_FILE = ConfigProperty.key("hoodie.streamer.schemaprovider.source.schema.file").noDefaultValue().withAlternatives("hoodie.deltastreamer.schemaprovider.source.schema.file").withDocumentation("The schema of the source you are reading from");
        private static final ConfigProperty<String> TARGET_SCHEMA_FILE = ConfigProperty.key("hoodie.streamer.schemaprovider.target.schema.file").noDefaultValue().withAlternatives("hoodie.deltastreamer.schemaprovider.target.schema.file").withDocumentation("The schema of the target you are writing to");
    }
}

