/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.storage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.PublicAPIMethod;

@PublicAPIClass(maturity=ApiMaturityLevel.EVOLVING)
public class StoragePath
implements Comparable<StoragePath>,
Serializable {
    public static final char SEPARATOR_CHAR = '/';
    public static final char COLON_CHAR = ':';
    public static final String SEPARATOR = "/";
    private URI uri;
    private volatile transient StoragePath cachedParent;
    private volatile transient String cachedName;
    private volatile transient String uriString;

    public StoragePath(URI uri2) {
        this.uri = uri2.normalize();
    }

    public StoragePath(String path) {
        try {
            String scheme2 = null;
            String authority = null;
            int start2 = 0;
            int colon = path.indexOf(58);
            int slash = path.indexOf(47);
            if (colon != -1 && (slash == -1 || colon < slash)) {
                scheme2 = path.substring(0, colon);
                start2 = colon + 1;
            }
            if (path.startsWith("//", start2) && path.length() - start2 > 2) {
                int nextSlash = path.indexOf(47, start2 + 2);
                int authEnd = nextSlash > 0 ? nextSlash : path.length();
                authority = path.substring(start2 + 2, authEnd);
                start2 = authEnd;
            }
            String uriPath = path.substring(start2);
            this.uri = new URI(scheme2, authority, StoragePath.normalize(uriPath, true), null, null).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public StoragePath(String parent, String child) {
        this(new StoragePath(parent), child);
    }

    public StoragePath(StoragePath parent, String child) {
        String parentPathWithSeparator;
        URI parentUri = parent.toUri();
        String normalizedChild = StoragePath.normalize(child, false);
        if (normalizedChild.isEmpty()) {
            this.uri = parentUri;
            return;
        }
        if (!child.contains(SEPARATOR)) {
            this.cachedParent = parent;
        }
        if (!(parentPathWithSeparator = parentUri.getPath()).endsWith(SEPARATOR)) {
            parentPathWithSeparator = parentPathWithSeparator + SEPARATOR;
        }
        try {
            URI resolvedUri = new URI(parentUri.getScheme(), parentUri.getAuthority(), parentPathWithSeparator, null, parentUri.getFragment()).resolve(new URI(null, null, normalizedChild, null, null));
            this.uri = new URI(parentUri.getScheme(), parentUri.getAuthority(), resolvedUri.getPath(), null, resolvedUri.getFragment()).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public boolean isAbsolute() {
        return this.uri.getPath().startsWith(SEPARATOR);
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public StoragePath getParent() {
        if (this.cachedParent == null) {
            String path = this.uri.getPath();
            int lastSlash = path.lastIndexOf(47);
            if (path.isEmpty() || path.equals(SEPARATOR)) {
                throw new IllegalStateException("Cannot get parent path of a root path");
            }
            String parentPath = lastSlash == -1 ? "" : path.substring(0, lastSlash == 0 ? 1 : lastSlash);
            try {
                this.cachedParent = new StoragePath(new URI(this.uri.getScheme(), this.uri.getAuthority(), parentPath, null, this.uri.getFragment()));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.cachedParent;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public String getName() {
        if (this.cachedName == null) {
            String path = this.uri.getPath();
            int slash = path.lastIndexOf(SEPARATOR);
            this.cachedName = path.substring(slash + 1);
        }
        return this.cachedName;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public StoragePath getPathWithoutSchemeAndAuthority() {
        try {
            return new StoragePath(new URI(null, null, this.uri.getPath(), this.uri.getQuery(), this.uri.getFragment()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public int depth() {
        int slash;
        String path = this.uri.getPath();
        int depth = 0;
        int n = slash = path.length() == 1 && path.charAt(0) == '/' ? -1 : 0;
        while (slash != -1) {
            ++depth;
            slash = path.indexOf(47, slash + 1);
        }
        return depth;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public URI toUri() {
        return this.uri;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public StoragePath makeQualified(URI defaultUri) {
        URI newUri;
        if (!this.isAbsolute()) {
            throw new IllegalStateException("Only an absolute path can be made qualified");
        }
        StoragePath path = this;
        URI pathUri = path.toUri();
        String scheme2 = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        String fragment = pathUri.getFragment();
        if (scheme2 != null && (authority != null || defaultUri.getAuthority() == null)) {
            return path;
        }
        if (scheme2 == null) {
            scheme2 = defaultUri.getScheme();
        }
        if (authority == null && (authority = defaultUri.getAuthority()) == null) {
            authority = "";
        }
        try {
            newUri = new URI(scheme2, authority, StoragePath.normalize(pathUri.getPath(), true), null, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return new StoragePath(newUri);
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public String getFileExtension() {
        String fileName = this.getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex);
    }

    public String toString() {
        if (this.uriString == null) {
            StringBuilder buffer = new StringBuilder();
            if (this.uri.getScheme() != null) {
                buffer.append(this.uri.getScheme()).append(":");
            }
            if (this.uri.getAuthority() != null) {
                buffer.append("//").append(this.uri.getAuthority());
            }
            if (this.uri.getPath() != null) {
                String path = this.uri.getPath();
                buffer.append(path);
            }
            if (this.uri.getFragment() != null) {
                buffer.append("#").append(this.uri.getFragment());
            }
            this.uriString = buffer.toString();
        }
        return this.uriString;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StoragePath)) {
            return false;
        }
        return this.uri.equals(((StoragePath)o).toUri());
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public int compareTo(StoragePath o) {
        return this.uri.compareTo(o.uri);
    }

    private static String normalize(String path, boolean keepSingleSlash) {
        int indexOfLastSlash;
        for (indexOfLastSlash = path.length() - 1; indexOfLastSlash >= 0 && path.charAt(indexOfLastSlash) == '/'; --indexOfLastSlash) {
        }
        if (++indexOfLastSlash == path.length()) {
            return path;
        }
        if (keepSingleSlash && indexOfLastSlash == 0) {
            return SEPARATOR;
        }
        return path.substring(0, indexOfLastSlash);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.uri);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.uri = (URI)in.readObject();
    }
}

