/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow.vector.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import org.apache.flink.formats.parquet.vector.reader.TimestampColumnReader;
import org.apache.flink.table.data.TimestampData;
import org.apache.hudi.table.format.cow.vector.reader.ParquetDataColumnReader;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public final class ParquetDataColumnReaderFactory {
    private ParquetDataColumnReaderFactory() {
    }

    private static ParquetDataColumnReader getDataColumnReaderByTypeHelper(boolean isDictionary, PrimitiveType parquetType, Dictionary dictionary, ValuesReader valuesReader, boolean isUtcTimestamp) {
        if (parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT96) {
            return isDictionary ? new TypesFromInt96PageReader(dictionary, isUtcTimestamp) : new TypesFromInt96PageReader(valuesReader, isUtcTimestamp);
        }
        return isDictionary ? new DefaultParquetDataColumnReader(dictionary) : new DefaultParquetDataColumnReader(valuesReader);
    }

    public static ParquetDataColumnReader getDataColumnReaderByTypeOnDictionary(PrimitiveType parquetType, Dictionary realReader, boolean isUtcTimestamp) {
        return ParquetDataColumnReaderFactory.getDataColumnReaderByTypeHelper(true, parquetType, realReader, null, isUtcTimestamp);
    }

    public static ParquetDataColumnReader getDataColumnReaderByType(PrimitiveType parquetType, ValuesReader realReader, boolean isUtcTimestamp) {
        return ParquetDataColumnReaderFactory.getDataColumnReaderByTypeHelper(false, parquetType, null, realReader, isUtcTimestamp);
    }

    private static TimestampData int96ToTimestamp(boolean utcTimestamp, long nanosOfDay, int julianDay) {
        long millisecond = ParquetDataColumnReaderFactory.julianDayToMillis(julianDay) + nanosOfDay / TimestampColumnReader.NANOS_PER_MILLISECOND;
        if (utcTimestamp) {
            int nanoOfMillisecond = (int)(nanosOfDay % TimestampColumnReader.NANOS_PER_MILLISECOND);
            return TimestampData.fromEpochMillis((long)millisecond, (int)nanoOfMillisecond);
        }
        Timestamp timestamp = new Timestamp(millisecond);
        timestamp.setNanos((int)(nanosOfDay % TimestampColumnReader.NANOS_PER_SECOND));
        return TimestampData.fromTimestamp((Timestamp)timestamp);
    }

    private static long julianDayToMillis(int julianDay) {
        return (long)(julianDay - 2440588) * TimestampColumnReader.MILLIS_IN_DAY;
    }

    public static class TypesFromInt96PageReader
    extends DefaultParquetDataColumnReader {
        private final boolean isUtcTimestamp;

        public TypesFromInt96PageReader(ValuesReader realReader, boolean isUtcTimestamp) {
            super(realReader);
            this.isUtcTimestamp = isUtcTimestamp;
        }

        public TypesFromInt96PageReader(Dictionary dict, boolean isUtcTimestamp) {
            super(dict);
            this.isUtcTimestamp = isUtcTimestamp;
        }

        private TimestampData convert(Binary binary) {
            ByteBuffer buf = binary.toByteBuffer();
            buf.order(ByteOrder.LITTLE_ENDIAN);
            long timeOfDayNanos = buf.getLong();
            int julianDay = buf.getInt();
            return ParquetDataColumnReaderFactory.int96ToTimestamp(this.isUtcTimestamp, timeOfDayNanos, julianDay);
        }

        @Override
        public TimestampData readTimestamp(int id) {
            return this.convert(this.dict.decodeToBinary(id));
        }

        @Override
        public TimestampData readTimestamp() {
            return this.convert(this.valuesReader.readBytes());
        }
    }

    public static class DefaultParquetDataColumnReader
    implements ParquetDataColumnReader {
        protected ValuesReader valuesReader;
        protected Dictionary dict;
        boolean isValid = true;

        public DefaultParquetDataColumnReader(ValuesReader valuesReader) {
            this.valuesReader = valuesReader;
        }

        public DefaultParquetDataColumnReader(Dictionary dict) {
            this.dict = dict;
        }

        @Override
        public void initFromPage(int i, ByteBufferInputStream in) throws IOException {
            this.valuesReader.initFromPage(i, in);
        }

        @Override
        public boolean readBoolean() {
            return this.valuesReader.readBoolean();
        }

        @Override
        public boolean readBoolean(int id) {
            return this.dict.decodeToBoolean(id);
        }

        @Override
        public byte[] readString(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readString() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readVarchar() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readVarchar(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readChar() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readChar(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readBytes() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readBytes(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public byte[] readDecimal() {
            return this.valuesReader.readBytes().getBytesUnsafe();
        }

        @Override
        public byte[] readDecimal(int id) {
            return this.dict.decodeToBinary(id).getBytesUnsafe();
        }

        @Override
        public float readFloat() {
            return this.valuesReader.readFloat();
        }

        @Override
        public float readFloat(int id) {
            return this.dict.decodeToFloat(id);
        }

        @Override
        public double readDouble() {
            return this.valuesReader.readDouble();
        }

        @Override
        public double readDouble(int id) {
            return this.dict.decodeToDouble(id);
        }

        @Override
        public TimestampData readTimestamp() {
            throw new RuntimeException("Unsupported operation");
        }

        @Override
        public TimestampData readTimestamp(int id) {
            throw new RuntimeException("Unsupported operation");
        }

        @Override
        public int readInteger() {
            return this.valuesReader.readInteger();
        }

        @Override
        public int readInteger(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public boolean isValid() {
            return this.isValid;
        }

        @Override
        public long readLong(int id) {
            return this.dict.decodeToLong(id);
        }

        @Override
        public long readLong() {
            return this.valuesReader.readLong();
        }

        @Override
        public int readSmallInt() {
            return this.valuesReader.readInteger();
        }

        @Override
        public int readSmallInt(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public int readTinyInt() {
            return this.valuesReader.readInteger();
        }

        @Override
        public int readTinyInt(int id) {
            return this.dict.decodeToInt(id);
        }

        @Override
        public int readValueDictionaryId() {
            return this.valuesReader.readValueDictionaryId();
        }

        public void skip() {
            this.valuesReader.skip();
        }

        @Override
        public Dictionary getDictionary() {
            return this.dict;
        }
    }
}

