/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.table.HoodieFlinkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;

public class FlinkUpgradeDowngradeHelper
implements SupportsUpgradeDowngrade {
    private static final FlinkUpgradeDowngradeHelper SINGLETON_INSTANCE = new FlinkUpgradeDowngradeHelper();

    private FlinkUpgradeDowngradeHelper() {
    }

    public static FlinkUpgradeDowngradeHelper getInstance() {
        return SINGLETON_INSTANCE;
    }

    @Override
    public HoodieTable getTable(HoodieWriteConfig config, HoodieEngineContext context) {
        return HoodieFlinkTable.create(config, context);
    }

    @Override
    public String getPartitionColumns(HoodieWriteConfig config) {
        return config.getProps().getProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key());
    }

    @Override
    public BaseHoodieWriteClient getWriteClient(HoodieWriteConfig config, HoodieEngineContext context) {
        return new HoodieFlinkWriteClient(context, config);
    }
}

