/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.hudi.common.util.Option;

public class SerializableSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Column> columns;

    private SerializableSchema(List<Column> columns) {
        this.columns = columns;
    }

    public static SerializableSchema create(ResolvedSchema resolvedSchema) {
        List<Column> columns = resolvedSchema.getColumns().stream().filter(org.apache.flink.table.catalog.Column::isPhysical).map(column -> Column.create(column.getName(), column.getDataType())).collect(Collectors.toList());
        return new SerializableSchema(columns);
    }

    public List<String> getColumnNames() {
        return this.columns.stream().map(Column::getName).collect(Collectors.toList());
    }

    public List<DataType> getColumnDataTypes() {
        return this.columns.stream().map(Column::getDataType).collect(Collectors.toList());
    }

    public Option<Column> getColumn(String columnName) {
        return Option.fromJavaOptional(this.columns.stream().filter(col -> col.getName().equals(columnName)).findFirst());
    }

    public DataType toSourceRowDataType() {
        return this.toRowDataType(c -> true);
    }

    private DataType toRowDataType(Predicate<Column> predicate) {
        DataTypes.Field[] fieldsArray = (DataTypes.Field[])this.columns.stream().filter(predicate).map(SerializableSchema::columnToField).toArray(DataTypes.Field[]::new);
        return (DataType)DataTypes.ROW((DataTypes.Field[])fieldsArray).notNull();
    }

    private static DataTypes.Field columnToField(Column column) {
        return DataTypes.FIELD((String)column.getName(), (DataType)DataTypeUtils.removeTimeAttribute((DataType)column.getDataType()));
    }

    public static class Column
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final DataType dataType;

        private Column(String name, DataType dataType) {
            this.name = name;
            this.dataType = dataType;
        }

        public static Column create(String name, DataType type) {
            return new Column(name, type);
        }

        public String getName() {
            return this.name;
        }

        public DataType getDataType() {
            return this.dataType;
        }
    }
}

