/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieNotSupportedException;

@ConfigClassProperty(name="Metadata Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations used by the Hudi Metadata Table. This table maintains the metadata about a given Hudi table (e.g file listings)  to avoid overhead of accessing cloud storage, during queries.")
@Immutable
public final class HoodieMetadataConfig
extends HoodieConfig {
    public static final boolean DEFAULT_METADATA_ASYNC_CLEAN = false;
    public static final boolean DEFAULT_METADATA_ENABLE_FULL_SCAN_LOG_FILES = true;
    public static final boolean DEFAULT_METADATA_POPULATE_META_FIELDS = false;
    public static final int DEFAULT_METADATA_CLEANER_COMMITS_RETAINED = 20;
    public static final String METADATA_PREFIX = "hoodie.metadata";
    public static final String OPTIMIZED_LOG_BLOCKS_SCAN = ".optimized.log.blocks.scan.enable";
    public static final ConfigProperty<Boolean> ENABLE = ConfigProperty.key("hoodie.metadata.enable").defaultValue(true).sinceVersion("0.7.0").withDocumentation("Enable the internal metadata table which serves table metadata like level file listings");
    public static final boolean DEFAULT_METADATA_ENABLE_FOR_READERS = false;
    public static final ConfigProperty<Boolean> METRICS_ENABLE = ConfigProperty.key("hoodie.metadata.metrics.enable").defaultValue(false).markAdvanced().sinceVersion("0.7.0").withDocumentation("Enable publishing of metrics around metadata table.");
    public static final ConfigProperty<Boolean> ASYNC_INDEX_ENABLE = ConfigProperty.key("hoodie.metadata.index.async").defaultValue(false).markAdvanced().sinceVersion("0.11.0").withDocumentation("Enable asynchronous indexing of metadata table.");
    public static final ConfigProperty<Integer> COMPACT_NUM_DELTA_COMMITS = ConfigProperty.key("hoodie.metadata.compact.max.delta.commits").defaultValue(10).markAdvanced().sinceVersion("0.7.0").withDocumentation("Controls how often the metadata table is compacted.");
    public static final ConfigProperty<String> ENABLE_LOG_COMPACTION_ON_METADATA_TABLE = ConfigProperty.key("hoodie.metadata.log.compaction.enable").defaultValue("false").markAdvanced().sinceVersion("0.14").withDocumentation("This configs enables logcompaction for the metadata table.");
    public static final ConfigProperty<Integer> LOG_COMPACT_BLOCKS_THRESHOLD = ConfigProperty.key("hoodie.metadata.log.compaction.blocks.threshold").defaultValue(5).markAdvanced().withDocumentation("Controls the criteria to log compacted files groups in metadata table.");
    public static final ConfigProperty<String> DIR_FILTER_REGEX = ConfigProperty.key("hoodie.metadata.dir.filter.regex").defaultValue("").markAdvanced().sinceVersion("0.7.0").withDocumentation("Directories matching this regex, will be filtered out when initializing metadata table from lake storage for the first time.");
    public static final ConfigProperty<String> ASSUME_DATE_PARTITIONING = ConfigProperty.key("hoodie.assume.date.partitioning").defaultValue("false").markAdvanced().sinceVersion("0.3.0").withDocumentation("Should HoodieWriteClient assume the data is partitioned by dates, i.e three levels from base path. This is a stop-gap to support tables created by versions < 0.3.1. Will be removed eventually");
    public static final ConfigProperty<Integer> FILE_LISTING_PARALLELISM_VALUE = ConfigProperty.key("hoodie.file.listing.parallelism").defaultValue(200).markAdvanced().sinceVersion("0.7.0").withDocumentation("Parallelism to use, when listing the table on lake storage.");
    public static final ConfigProperty<Boolean> ENABLE_METADATA_INDEX_BLOOM_FILTER = ConfigProperty.key("hoodie.metadata.index.bloom.filter.enable").defaultValue(false).sinceVersion("0.11.0").withDocumentation("Enable indexing bloom filters of user data files under metadata table. When enabled, metadata table will have a partition to store the bloom filter index and will be used during the index lookups.");
    public static final ConfigProperty<Integer> METADATA_INDEX_BLOOM_FILTER_FILE_GROUP_COUNT = ConfigProperty.key("hoodie.metadata.index.bloom.filter.file.group.count").defaultValue(4).markAdvanced().sinceVersion("0.11.0").withDocumentation("Metadata bloom filter index partition file group count. This controls the size of the base and log files and read parallelism in the bloom filter index partition. The recommendation is to size the file group count such that the base files are under 1GB.");
    public static final ConfigProperty<Integer> BLOOM_FILTER_INDEX_PARALLELISM = ConfigProperty.key("hoodie.metadata.index.bloom.filter.parallelism").defaultValue(200).markAdvanced().sinceVersion("0.11.0").withDocumentation("Parallelism to use for generating bloom filter index in metadata table.");
    public static final ConfigProperty<Boolean> ENABLE_METADATA_INDEX_COLUMN_STATS = ConfigProperty.key("hoodie.metadata.index.column.stats.enable").defaultValue(false).sinceVersion("0.11.0").withDocumentation("Enable indexing column ranges of user data files under metadata table key lookups. When enabled, metadata table will have a partition to store the column ranges and will be used for pruning files during the index lookups.");
    public static final ConfigProperty<Integer> METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT = ConfigProperty.key("hoodie.metadata.index.column.stats.file.group.count").defaultValue(2).markAdvanced().sinceVersion("0.11.0").withDocumentation("Metadata column stats partition file group count. This controls the size of the base and log files and read parallelism in the column stats index partition. The recommendation is to size the file group count such that the base files are under 1GB.");
    public static final ConfigProperty<Integer> COLUMN_STATS_INDEX_PARALLELISM = ConfigProperty.key("hoodie.metadata.index.column.stats.parallelism").defaultValue(200).markAdvanced().sinceVersion("0.11.0").withDocumentation("Parallelism to use, when generating column stats index.");
    public static final ConfigProperty<String> COLUMN_STATS_INDEX_FOR_COLUMNS = ConfigProperty.key("hoodie.metadata.index.column.stats.column.list").noDefaultValue().markAdvanced().sinceVersion("0.11.0").withDocumentation("Comma-separated list of columns for which column stats index will be built. If not set, all columns will be indexed");
    public static final String COLUMN_STATS_INDEX_PROCESSING_MODE_IN_MEMORY = "in-memory";
    public static final String COLUMN_STATS_INDEX_PROCESSING_MODE_ENGINE = "engine";
    public static final ConfigProperty<String> COLUMN_STATS_INDEX_PROCESSING_MODE_OVERRIDE = ConfigProperty.key("hoodie.metadata.index.column.stats.processing.mode.override").noDefaultValue().withValidValues("in-memory", "engine").markAdvanced().sinceVersion("0.12.0").withDocumentation("By default Column Stats Index is automatically determining whether it should be read and processed either'in-memory' (w/in executing process) or using Spark (on a cluster), based on some factors like the size of the Index and how many columns are read. This config allows to override this behavior.");
    public static final ConfigProperty<Integer> COLUMN_STATS_INDEX_IN_MEMORY_PROJECTION_THRESHOLD = ConfigProperty.key("hoodie.metadata.index.column.stats.inMemory.projection.threshold").defaultValue(100000).markAdvanced().sinceVersion("0.12.0").withDocumentation("When reading Column Stats Index, if the size of the expected resulting projection is below the in-memory threshold (counted by the # of rows), it will be attempted to be loaded \"in-memory\" (ie not using the execution engine like Spark, Flink, etc). If the value is above the threshold execution engine will be used to compose the projection.");
    public static final ConfigProperty<String> BLOOM_FILTER_INDEX_FOR_COLUMNS = ConfigProperty.key("hoodie.metadata.index.bloom.filter.column.list").noDefaultValue().markAdvanced().sinceVersion("0.11.0").withDocumentation("Comma-separated list of columns for which bloom filter index will be built. If not set, only record key will be indexed.");
    public static final ConfigProperty<Integer> METADATA_INDEX_CHECK_TIMEOUT_SECONDS = ConfigProperty.key("hoodie.metadata.index.check.timeout.seconds").defaultValue(900).markAdvanced().sinceVersion("0.11.0").withDocumentation("After the async indexer has finished indexing upto the base instant, it will ensure that all inflight writers reliably write index updates as well. If this timeout expires, then the indexer will abort itself safely.");
    public static final ConfigProperty<Boolean> IGNORE_SPURIOUS_DELETES = ConfigProperty.key("_hoodie.metadata.ignore.spurious.deletes").defaultValue(true).markAdvanced().sinceVersion("0.10.0").withDocumentation("There are cases when extra files are requested to be deleted from metadata table which are never added before. This config determines how to handle such spurious deletes");
    public static final ConfigProperty<Boolean> ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN = ConfigProperty.key("hoodie.metadata.optimized.log.blocks.scan.enable").defaultValue(false).markAdvanced().sinceVersion("0.13.0").withDocumentation("Optimized log blocks scanner that addresses all the multi-writer use-cases while appending to log files. It also differentiates original blocks written by ingestion writers and compacted blocks written by log compaction.");
    public static final ConfigProperty<Integer> METADATA_MAX_NUM_DELTACOMMITS_WHEN_PENDING = ConfigProperty.key("hoodie.metadata.max.deltacommits.when_pending").defaultValue(1000).markAdvanced().sinceVersion("0.14.0").withDocumentation("When there is a pending instant in data table, this config limits the allowed number of deltacommits in metadata table to prevent the metadata table's timeline from growing unboundedly as compaction won't be triggered due to the pending data table instant.");
    public static final ConfigProperty<Boolean> RECORD_INDEX_ENABLE_PROP = ConfigProperty.key("hoodie.metadata.record.index.enable").defaultValue(false).markAdvanced().sinceVersion("0.14.0").withDocumentation("Create the HUDI Record Index within the Metadata Table");
    public static final ConfigProperty<Integer> RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP = ConfigProperty.key("hoodie.metadata.record.index.min.filegroup.count").defaultValue(10).markAdvanced().sinceVersion("0.14.0").withDocumentation("Minimum number of file groups to use for Record Index.");
    public static final ConfigProperty<Integer> RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP = ConfigProperty.key("hoodie.metadata.record.index.max.filegroup.count").defaultValue(10000).markAdvanced().sinceVersion("0.14.0").withDocumentation("Maximum number of file groups to use for Record Index.");
    public static final ConfigProperty<Integer> RECORD_INDEX_MAX_FILE_GROUP_SIZE_BYTES_PROP = ConfigProperty.key("hoodie.metadata.record.index.max.filegroup.size").defaultValue(0x40000000).markAdvanced().sinceVersion("0.14.0").withDocumentation("Maximum size in bytes of a single file group. Large file group takes longer to compact.");
    public static final ConfigProperty<Float> RECORD_INDEX_GROWTH_FACTOR_PROP = ConfigProperty.key("hoodie.metadata.record.index.growth.factor").defaultValue(Float.valueOf(2.0f)).markAdvanced().sinceVersion("0.14.0").withDocumentation("The current number of records are multiplied by this number when estimating the number of file groups to create automatically. This helps account for growth in the number of records in the dataset.");
    public static final ConfigProperty<Integer> RECORD_INDEX_MAX_PARALLELISM = ConfigProperty.key("hoodie.metadata.max.init.parallelism").defaultValue(100000).sinceVersion("0.14.0").withDocumentation("Maximum parallelism to use when initializing Record Index.");
    public static final ConfigProperty<Long> MAX_READER_MEMORY_PROP = ConfigProperty.key("hoodie.metadata.max.reader.memory").defaultValue(0x40000000L).markAdvanced().sinceVersion("0.14.0").withDocumentation("Max memory to use for the reader to read from metadata");
    public static final ConfigProperty<Integer> MAX_READER_BUFFER_SIZE_PROP = ConfigProperty.key("hoodie.metadata.max.reader.buffer.size").defaultValue(0xA00000).markAdvanced().sinceVersion("0.14.0").withDocumentation("Max memory to use for the reader buffer while merging log blocks");
    public static final ConfigProperty<String> SPILLABLE_MAP_DIR_PROP = ConfigProperty.key("hoodie.metadata.spillable.map.path").noDefaultValue().withInferFunction(cfg -> Option.of(cfg.getStringOrDefault(FileSystemViewStorageConfig.SPILLABLE_DIR))).markAdvanced().sinceVersion("0.14.0").withDocumentation("Path on local storage to use, when keys read from metadata are held in a spillable map.");
    public static final ConfigProperty<Long> MAX_LOG_FILE_SIZE_BYTES_PROP = ConfigProperty.key("hoodie.metadata.max.logfile.size").defaultValue(0x80000000L).sinceVersion("0.14.0").withDocumentation("Maximum size in bytes of a single log file. Larger log files can contain larger log blocks thereby reducing the number of blocks to search for keys");
    public static final ConfigProperty<Boolean> AUTO_INITIALIZE = ConfigProperty.key("hoodie.metadata.auto.initialize").defaultValue(true).sinceVersion("0.14.0").markAdvanced().withDocumentation("Initializes the metadata table by reading from the file system when the table is first created. Enabled by default. Warning: This should only be disabled when manually constructing the metadata table outside of typical Hudi writer flows.");
    @Deprecated
    public static final String METADATA_ENABLE_PROP = ENABLE.key();
    @Deprecated
    public static final boolean DEFAULT_METADATA_ENABLE = ENABLE.defaultValue();
    @Deprecated
    public static final String METADATA_METRICS_ENABLE_PROP = METRICS_ENABLE.key();
    @Deprecated
    public static final boolean DEFAULT_METADATA_METRICS_ENABLE = METRICS_ENABLE.defaultValue();
    @Deprecated
    public static final String METADATA_COMPACT_NUM_DELTA_COMMITS_PROP = COMPACT_NUM_DELTA_COMMITS.key();
    @Deprecated
    public static final int DEFAULT_METADATA_COMPACT_NUM_DELTA_COMMITS = COMPACT_NUM_DELTA_COMMITS.defaultValue();
    @Deprecated
    public static final String ENABLE_FALLBACK_PROP = "hoodie.metadata.fallback.enable";
    @Deprecated
    public static final String DEFAULT_ENABLE_FALLBACK = "true";
    @Deprecated
    public static final String DIRECTORY_FILTER_REGEX = DIR_FILTER_REGEX.key();
    @Deprecated
    public static final String DEFAULT_DIRECTORY_FILTER_REGEX = DIR_FILTER_REGEX.defaultValue();
    @Deprecated
    public static final String HOODIE_ASSUME_DATE_PARTITIONING_PROP = ASSUME_DATE_PARTITIONING.key();
    @Deprecated
    public static final String DEFAULT_ASSUME_DATE_PARTITIONING = ASSUME_DATE_PARTITIONING.defaultValue();
    @Deprecated
    public static final String FILE_LISTING_PARALLELISM_PROP = FILE_LISTING_PARALLELISM_VALUE.key();
    @Deprecated
    public static final int DEFAULT_FILE_LISTING_PARALLELISM = FILE_LISTING_PARALLELISM_VALUE.defaultValue();

    public long getMaxLogFileSize() {
        return this.getLong(MAX_LOG_FILE_SIZE_BYTES_PROP);
    }

    private HoodieMetadataConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getFileListingParallelism() {
        return Math.max(this.getInt(FILE_LISTING_PARALLELISM_VALUE), 1);
    }

    public Boolean shouldAssumeDatePartitioning() {
        return this.getBoolean(ASSUME_DATE_PARTITIONING);
    }

    public boolean enabled() {
        return this.getBoolean(ENABLE);
    }

    public boolean isBloomFilterIndexEnabled() {
        return this.getBooleanOrDefault(ENABLE_METADATA_INDEX_BLOOM_FILTER);
    }

    public boolean isColumnStatsIndexEnabled() {
        return this.getBooleanOrDefault(ENABLE_METADATA_INDEX_COLUMN_STATS);
    }

    public boolean isRecordIndexEnabled() {
        return this.getBooleanOrDefault(RECORD_INDEX_ENABLE_PROP);
    }

    public List<String> getColumnsEnabledForColumnStatsIndex() {
        return StringUtils.split(this.getString(COLUMN_STATS_INDEX_FOR_COLUMNS), ",");
    }

    public String getColumnStatsIndexProcessingModeOverride() {
        return this.getString(COLUMN_STATS_INDEX_PROCESSING_MODE_OVERRIDE);
    }

    public Integer getColumnStatsIndexInMemoryProjectionThreshold() {
        return this.getIntOrDefault(COLUMN_STATS_INDEX_IN_MEMORY_PROJECTION_THRESHOLD);
    }

    public List<String> getColumnsEnabledForBloomFilterIndex() {
        return StringUtils.split(this.getString(BLOOM_FILTER_INDEX_FOR_COLUMNS), ",");
    }

    public int getBloomFilterIndexFileGroupCount() {
        return this.getIntOrDefault(METADATA_INDEX_BLOOM_FILTER_FILE_GROUP_COUNT);
    }

    public int getColumnStatsIndexFileGroupCount() {
        return this.getIntOrDefault(METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT);
    }

    public int getBloomFilterIndexParallelism() {
        return this.getIntOrDefault(BLOOM_FILTER_INDEX_PARALLELISM);
    }

    public int getColumnStatsIndexParallelism() {
        return this.getIntOrDefault(COLUMN_STATS_INDEX_PARALLELISM);
    }

    public int getIndexingCheckTimeoutSeconds() {
        return this.getIntOrDefault(METADATA_INDEX_CHECK_TIMEOUT_SECONDS);
    }

    public boolean enableMetrics() {
        return this.getBoolean(METRICS_ENABLE);
    }

    public String getDirectoryFilterRegex() {
        return this.getString(DIR_FILTER_REGEX);
    }

    public boolean ignoreSpuriousDeletes() {
        return this.getBoolean(IGNORE_SPURIOUS_DELETES);
    }

    public boolean doEnableOptimizedLogBlocksScan() {
        return this.getBoolean(ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN);
    }

    public int getMaxNumDeltacommitsWhenPending() {
        return this.getIntOrDefault(METADATA_MAX_NUM_DELTACOMMITS_WHEN_PENDING);
    }

    public boolean enableRecordIndex() {
        return this.enabled() && this.getBoolean(RECORD_INDEX_ENABLE_PROP) != false;
    }

    public int getRecordIndexMinFileGroupCount() {
        return this.getInt(RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP);
    }

    public int getRecordIndexMaxFileGroupCount() {
        return this.getInt(RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP);
    }

    public float getRecordIndexGrowthFactor() {
        return this.getFloat(RECORD_INDEX_GROWTH_FACTOR_PROP).floatValue();
    }

    public int getRecordIndexMaxFileGroupSizeBytes() {
        return this.getInt(RECORD_INDEX_MAX_FILE_GROUP_SIZE_BYTES_PROP);
    }

    public String getSplliableMapDir() {
        return this.getString(SPILLABLE_MAP_DIR_PROP);
    }

    public long getMaxReaderMemory() {
        return this.getLong(MAX_READER_MEMORY_PROP);
    }

    public int getMaxReaderBufferSize() {
        return this.getInt(MAX_READER_BUFFER_SIZE_PROP);
    }

    public int getRecordIndexMaxParallelism() {
        return this.getInt(RECORD_INDEX_MAX_PARALLELISM);
    }

    public boolean shouldAutoInitialize() {
        return this.getBoolean(AUTO_INITIALIZE);
    }

    public static class Builder {
        private EngineType engineType = EngineType.SPARK;
        private final HoodieMetadataConfig metadataConfig = new HoodieMetadataConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.metadataConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.metadataConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder enable(boolean enable) {
            this.metadataConfig.setValue(ENABLE, String.valueOf(enable));
            return this;
        }

        public Builder withMetadataIndexBloomFilter(boolean enable) {
            this.metadataConfig.setValue(ENABLE_METADATA_INDEX_BLOOM_FILTER, String.valueOf(enable));
            return this;
        }

        public Builder withMetadataIndexBloomFilterFileGroups(int fileGroupCount) {
            this.metadataConfig.setValue(METADATA_INDEX_BLOOM_FILTER_FILE_GROUP_COUNT, String.valueOf(fileGroupCount));
            return this;
        }

        public Builder withBloomFilterIndexParallelism(int parallelism) {
            this.metadataConfig.setValue(BLOOM_FILTER_INDEX_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withMetadataIndexColumnStats(boolean enable) {
            this.metadataConfig.setValue(ENABLE_METADATA_INDEX_COLUMN_STATS, String.valueOf(enable));
            return this;
        }

        public Builder withMetadataIndexColumnStatsFileGroupCount(int fileGroupCount) {
            this.metadataConfig.setValue(METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT, String.valueOf(fileGroupCount));
            return this;
        }

        public Builder withColumnStatsIndexParallelism(int parallelism) {
            this.metadataConfig.setValue(COLUMN_STATS_INDEX_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withColumnStatsIndexForColumns(String columns) {
            this.metadataConfig.setValue(COLUMN_STATS_INDEX_FOR_COLUMNS, columns);
            return this;
        }

        public Builder withBloomFilterIndexForColumns(String columns) {
            this.metadataConfig.setValue(BLOOM_FILTER_INDEX_FOR_COLUMNS, columns);
            return this;
        }

        public Builder withIndexingCheckTimeout(int timeoutInSeconds) {
            this.metadataConfig.setValue(METADATA_INDEX_CHECK_TIMEOUT_SECONDS, String.valueOf(timeoutInSeconds));
            return this;
        }

        public Builder enableMetrics(boolean enableMetrics) {
            this.metadataConfig.setValue(METRICS_ENABLE, String.valueOf(enableMetrics));
            return this;
        }

        public Builder withAsyncIndex(boolean asyncIndex) {
            this.metadataConfig.setValue(ASYNC_INDEX_ENABLE, String.valueOf(asyncIndex));
            return this;
        }

        public Builder withMaxNumDeltaCommitsBeforeCompaction(int maxNumDeltaCommitsBeforeCompaction) {
            this.metadataConfig.setValue(COMPACT_NUM_DELTA_COMMITS, String.valueOf(maxNumDeltaCommitsBeforeCompaction));
            return this;
        }

        public Builder withLogCompactionEnabled(boolean enableLogCompaction) {
            this.metadataConfig.setValue(ENABLE_LOG_COMPACTION_ON_METADATA_TABLE, Boolean.toString(enableLogCompaction));
            return this;
        }

        public Builder withLogCompactBlocksThreshold(int logCompactBlocksThreshold) {
            this.metadataConfig.setValue(LOG_COMPACT_BLOCKS_THRESHOLD, Integer.toString(logCompactBlocksThreshold));
            return this;
        }

        public Builder withFileListingParallelism(int parallelism) {
            this.metadataConfig.setValue(FILE_LISTING_PARALLELISM_VALUE, String.valueOf(parallelism));
            return this;
        }

        public Builder withRecordIndexMaxParallelism(int parallelism) {
            this.metadataConfig.setValue(RECORD_INDEX_MAX_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withAssumeDatePartitioning(boolean assumeDatePartitioning) {
            this.metadataConfig.setValue(ASSUME_DATE_PARTITIONING, String.valueOf(assumeDatePartitioning));
            return this;
        }

        public Builder withDirectoryFilterRegex(String regex2) {
            this.metadataConfig.setValue(DIR_FILTER_REGEX, regex2);
            return this;
        }

        public Builder ignoreSpuriousDeletes(boolean validateMetadataPayloadConsistency) {
            this.metadataConfig.setValue(IGNORE_SPURIOUS_DELETES, String.valueOf(validateMetadataPayloadConsistency));
            return this;
        }

        public Builder withEngineType(EngineType engineType) {
            this.engineType = engineType;
            return this;
        }

        public Builder withProperties(Properties properties) {
            this.metadataConfig.getProps().putAll((Map<?, ?>)properties);
            return this;
        }

        public Builder withOptimizedLogBlocksScan(boolean enableOptimizedLogBlocksScan) {
            this.metadataConfig.setValue(ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN, String.valueOf(enableOptimizedLogBlocksScan));
            return this;
        }

        public Builder withMaxNumDeltacommitsWhenPending(int maxNumDeltaCommitsWhenPending) {
            this.metadataConfig.setValue(METADATA_MAX_NUM_DELTACOMMITS_WHEN_PENDING, String.valueOf(maxNumDeltaCommitsWhenPending));
            return this;
        }

        public Builder withEnableRecordIndex(boolean enabled) {
            this.metadataConfig.setValue(RECORD_INDEX_ENABLE_PROP, String.valueOf(enabled));
            return this;
        }

        public Builder withRecordIndexFileGroupCount(int minCount, int maxCount) {
            this.metadataConfig.setValue(RECORD_INDEX_MIN_FILE_GROUP_COUNT_PROP, String.valueOf(minCount));
            this.metadataConfig.setValue(RECORD_INDEX_MAX_FILE_GROUP_COUNT_PROP, String.valueOf(maxCount));
            return this;
        }

        public Builder withRecordIndexGrowthFactor(float factor) {
            this.metadataConfig.setValue(RECORD_INDEX_GROWTH_FACTOR_PROP, String.valueOf(factor));
            return this;
        }

        public Builder withRecordIndexMaxFileGroupSizeBytes(long sizeInBytes) {
            this.metadataConfig.setValue(RECORD_INDEX_MAX_FILE_GROUP_SIZE_BYTES_PROP, String.valueOf(sizeInBytes));
            return this;
        }

        public Builder withSpillableMapDir(String dir) {
            this.metadataConfig.setValue(SPILLABLE_MAP_DIR_PROP, dir);
            return this;
        }

        public Builder withMaxReaderMemory(long mem) {
            this.metadataConfig.setValue(MAX_READER_MEMORY_PROP, String.valueOf(mem));
            return this;
        }

        public Builder withMaxReaderBufferSize(long mem) {
            this.metadataConfig.setValue(MAX_READER_BUFFER_SIZE_PROP, String.valueOf(mem));
            return this;
        }

        public Builder withMaxLogFileSizeBytes(long sizeInBytes) {
            this.metadataConfig.setValue(MAX_LOG_FILE_SIZE_BYTES_PROP, String.valueOf(sizeInBytes));
            return this;
        }

        public HoodieMetadataConfig build() {
            this.metadataConfig.setDefaultValue(ENABLE, this.getDefaultMetadataEnable(this.engineType));
            this.metadataConfig.setDefaults(HoodieMetadataConfig.class.getName());
            return this.metadataConfig;
        }

        private boolean getDefaultMetadataEnable(EngineType engineType) {
            switch (engineType) {
                case FLINK: 
                case SPARK: {
                    return ENABLE.defaultValue();
                }
                case JAVA: {
                    return false;
                }
            }
            throw new HoodieNotSupportedException("Unsupported engine " + (Object)((Object)engineType));
        }
    }
}

