/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import org.apache.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.collection.Pair;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClusteringOpDTO {
    @JsonProperty(value="id")
    private String fileId;
    @JsonProperty(value="partition")
    private String partitionPath;
    @JsonProperty(value="instantTime")
    private String instantTime;
    @JsonProperty(value="instantState")
    private String instantState;
    @JsonProperty(value="instantAction")
    private String instantAction;

    public static ClusteringOpDTO fromClusteringOp(HoodieFileGroupId fileGroupId, HoodieInstant instant) {
        ClusteringOpDTO dto = new ClusteringOpDTO();
        dto.fileId = fileGroupId.getFileId();
        dto.partitionPath = fileGroupId.getPartitionPath();
        dto.instantAction = instant.getAction();
        dto.instantState = instant.getState().name();
        dto.instantTime = instant.getTimestamp();
        return dto;
    }

    public static Pair<HoodieFileGroupId, HoodieInstant> toClusteringOperation(ClusteringOpDTO dto) {
        return Pair.of(new HoodieFileGroupId(dto.partitionPath, dto.fileId), new HoodieInstant(HoodieInstant.State.valueOf(dto.instantState), dto.instantAction, dto.instantTime));
    }
}

