/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.com.esotericsoftware.kryo.Kryo;
import org.apache.hudi.com.esotericsoftware.kryo.KryoSerializable;
import org.apache.hudi.com.esotericsoftware.kryo.io.Input;
import org.apache.hudi.com.esotericsoftware.kryo.io.Output;

public class FlatLists {
    private FlatLists() {
    }

    public static <T> List<T> of(List<T> t) {
        return FlatLists.of_(t);
    }

    public static <T extends Comparable> ComparableList<T> ofComparable(List<T> t) {
        return FlatLists.of_(t);
    }

    public static <T extends Comparable> ComparableList<T> ofComparableArray(Object[] t) {
        return FlatLists.ofComparable(Arrays.stream(t).map(v -> (Comparable)v).collect(Collectors.toList()));
    }

    private static <T> ComparableList<T> of_(List<T> t) {
        return new ComparableListImpl<T>(new ArrayList<T>(t));
    }

    static class ComparableListImpl<T extends Comparable<T>>
    extends AbstractList<T>
    implements ComparableList<T>,
    KryoSerializable {
        private List<T> list;

        protected ComparableListImpl(List<T> list) {
            this.list = list;
        }

        @Override
        public T get(int index) {
            return (T)((Comparable)this.list.get(index));
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public int compareTo(List o) {
            return ComparableListImpl.compare(this.list, o);
        }

        static <T extends Comparable<T>> int compare(List<T> list0, List<T> list1) {
            int size0 = list0.size();
            int size1 = list1.size();
            if (size1 == size0) {
                return ComparableListImpl.compare(list0, list1, size0);
            }
            int c = ComparableListImpl.compare(list0, list1, Math.min(size0, size1));
            if (c != 0) {
                return c;
            }
            return size0 - size1;
        }

        static <T extends Comparable<T>> int compare(List<T> list0, List<T> list1, int size) {
            for (int i = 0; i < size; ++i) {
                Comparable o1;
                Comparable o0 = (Comparable)list0.get(i);
                int c = ComparableListImpl.compare(o0, o1 = (Comparable)list1.get(i));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }

        static <T extends Comparable<T>> int compare(T a, T b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return a.compareTo(b);
        }

        @Override
        public void write(Kryo kryo, Output output) {
            kryo.writeClassAndObject(output, this.list);
        }

        @Override
        public void read(Kryo kryo, Input input) {
            this.list = (List)kryo.readClassAndObject(input);
        }
    }

    public static interface ComparableList<T>
    extends List<T>,
    Comparable<List> {
    }
}

