/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.model.AbstractHoodieRowData;
import org.apache.hudi.client.model.HoodieRowDataCreation;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordDelegate;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.io.storage.row.HoodieRowDataFileWriter;
import org.apache.hudi.io.storage.row.HoodieRowDataFileWriterFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieRowDataCreateHandle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HoodieRowDataCreateHandle.class);
    private static final AtomicLong SEQGEN = new AtomicLong(1L);
    private final String instantTime;
    private final int taskPartitionId;
    private final long taskId;
    private final long taskEpochId;
    private final HoodieTable table;
    private final HoodieWriteConfig writeConfig;
    protected final HoodieRowDataFileWriter fileWriter;
    private final String partitionPath;
    private final Path path;
    private final String fileId;
    private final boolean preserveHoodieMetadata;
    private final FileSystem fs;
    protected final WriteStatus writeStatus;
    private final HoodieRecordLocation newRecordLocation;
    private final HoodieTimer currTimer;

    public HoodieRowDataCreateHandle(HoodieTable table, HoodieWriteConfig writeConfig, String partitionPath, String fileId, String instantTime, int taskPartitionId, long taskId, long taskEpochId, RowType rowType, boolean preserveHoodieMetadata) {
        this.partitionPath = partitionPath;
        this.table = table;
        this.writeConfig = writeConfig;
        this.instantTime = instantTime;
        this.taskPartitionId = taskPartitionId;
        this.taskId = taskId;
        this.taskEpochId = taskEpochId;
        this.fileId = fileId;
        this.newRecordLocation = new HoodieRecordLocation(instantTime, fileId);
        this.preserveHoodieMetadata = preserveHoodieMetadata;
        this.currTimer = HoodieTimer.start();
        this.fs = table.getMetaClient().getFs();
        this.path = this.makeNewPath(partitionPath);
        this.writeStatus = new WriteStatus(table.shouldTrackSuccessRecords(), writeConfig.getWriteStatusFailureFraction());
        this.writeStatus.setPartitionPath(partitionPath);
        this.writeStatus.setFileId(fileId);
        this.writeStatus.setStat(new HoodieWriteStat());
        try {
            HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(this.fs, instantTime, new Path(writeConfig.getBasePath()), FSUtils.getPartitionPath(writeConfig.getBasePath(), partitionPath), table.getPartitionMetafileFormat());
            partitionMetadata.trySave(taskPartitionId);
            this.createMarkerFile(partitionPath, FSUtils.makeBaseFileName(this.instantTime, this.getWriteToken(), this.fileId, table.getBaseFileExtension()));
            this.fileWriter = this.createNewFileWriter(this.path, table, writeConfig, rowType);
        }
        catch (IOException e) {
            throw new HoodieInsertException("Failed to initialize file writer for path " + this.path, e);
        }
        LOG.info("New handle created for partition :" + partitionPath + " with fileId " + fileId);
    }

    public void write(String recordKey, String partitionPath, RowData record) throws IOException {
        try {
            String seqId = this.preserveHoodieMetadata ? record.getString(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD_ORD).toString() : HoodieRecord.generateSequenceId(this.instantTime, this.taskPartitionId, SEQGEN.getAndIncrement());
            String commitInstant = this.preserveHoodieMetadata ? record.getString(HoodieRecord.COMMIT_TIME_METADATA_FIELD_ORD).toString() : this.instantTime;
            AbstractHoodieRowData rowData = HoodieRowDataCreation.create(commitInstant, seqId, recordKey, partitionPath, this.path.getName(), record, this.writeConfig.allowOperationMetadataField(), this.preserveHoodieMetadata);
            try {
                this.fileWriter.writeRow(recordKey, rowData);
                HoodieRecordDelegate recordDelegate = this.writeStatus.isTrackingSuccessfulWrites() ? HoodieRecordDelegate.create(recordKey, partitionPath, null, this.newRecordLocation) : null;
                this.writeStatus.markSuccess(recordDelegate, Option.empty());
            }
            catch (Throwable t) {
                this.writeStatus.markFailure(recordKey, partitionPath, t);
            }
        }
        catch (Throwable ge) {
            this.writeStatus.setGlobalError(ge);
            throw ge;
        }
    }

    public boolean canWrite() {
        return this.fileWriter.canWrite();
    }

    public WriteStatus close() throws IOException {
        this.fileWriter.close();
        HoodieWriteStat stat = this.writeStatus.getStat();
        stat.setPartitionPath(this.partitionPath);
        stat.setNumWrites(this.writeStatus.getTotalRecords());
        stat.setNumDeletes(0L);
        stat.setNumInserts(this.writeStatus.getTotalRecords());
        stat.setPrevCommit("null");
        stat.setFileId(this.fileId);
        stat.setPath(new Path(this.writeConfig.getBasePath()), this.path);
        long fileSizeInBytes = FSUtils.getFileSize(this.table.getMetaClient().getFs(), this.path);
        stat.setTotalWriteBytes(fileSizeInBytes);
        stat.setFileSizeInBytes(fileSizeInBytes);
        stat.setTotalWriteErrors(this.writeStatus.getTotalErrorRecords());
        HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
        runtimeStats.setTotalCreateTime(this.currTimer.endTimer());
        stat.setRuntimeStats(runtimeStats);
        return this.writeStatus;
    }

    public String getFileName() {
        return this.path.getName();
    }

    private Path makeNewPath(String partitionPath) {
        Path path = FSUtils.getPartitionPath(this.writeConfig.getBasePath(), partitionPath);
        try {
            if (!this.fs.exists(path)) {
                this.fs.mkdirs(path);
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to make dir " + path, e);
        }
        HoodieTableConfig tableConfig = this.table.getMetaClient().getTableConfig();
        return new Path(path.toString(), FSUtils.makeBaseFileName(this.instantTime, this.getWriteToken(), this.fileId, tableConfig.getBaseFileFormat().getFileExtension()));
    }

    private void createMarkerFile(String partitionPath, String dataFileName) {
        WriteMarkers writeMarkers = WriteMarkersFactory.get(this.writeConfig.getMarkersType(), this.table, this.instantTime);
        writeMarkers.create(partitionPath, dataFileName, IOType.CREATE);
    }

    private String getWriteToken() {
        return this.taskPartitionId + "-" + this.taskId + "-" + this.taskEpochId;
    }

    protected HoodieRowDataFileWriter createNewFileWriter(Path path, HoodieTable hoodieTable, HoodieWriteConfig config, RowType rowType) throws IOException {
        return HoodieRowDataFileWriterFactory.getRowDataFileWriter(path, hoodieTable, config, rowType);
    }
}

