/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.List;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;

public class AutoRecordGenWrapperAvroKeyGenerator
extends BaseKeyGenerator {
    private final BaseKeyGenerator keyGenerator;
    private final int partitionId;
    private final String instantTime;
    private int rowId;

    public AutoRecordGenWrapperAvroKeyGenerator(TypedProperties config, BaseKeyGenerator keyGenerator) {
        super(config);
        this.keyGenerator = keyGenerator;
        this.rowId = 0;
        this.partitionId = config.getInteger("_hoodie.record.key.gen.partition.id");
        this.instantTime = config.getString("_hoodie.record.key.gen.instant.time");
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return HoodieRecord.generateSequenceId(this.instantTime, this.partitionId, this.rowId++);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return this.keyGenerator.getPartitionPath(record);
    }

    @Override
    public List<String> getRecordKeyFieldNames() {
        return this.keyGenerator.getRecordKeyFieldNames();
    }

    @Override
    public List<String> getPartitionPathFields() {
        return this.keyGenerator.getPartitionPathFields();
    }

    @Override
    public boolean isConsistentLogicalTimestampEnabled() {
        return this.keyGenerator.isConsistentLogicalTimestampEnabled();
    }
}

