/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Collections;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;

public class SimpleAvroKeyGenerator
extends BaseKeyGenerator {
    public SimpleAvroKeyGenerator(TypedProperties props) {
        this(props, Option.ofNullable(props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), null)), props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
    }

    SimpleAvroKeyGenerator(TypedProperties props, String partitionPathField) {
        this(props, Option.empty(), partitionPathField);
    }

    SimpleAvroKeyGenerator(TypedProperties props, Option<String> recordKeyField, String partitionPathField) {
        super(props);
        this.recordKeyFields = recordKeyField.map(keyField -> Collections.singletonList(keyField)).orElse(Collections.emptyList());
        this.partitionPathFields = Collections.singletonList(partitionPathField);
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return KeyGenUtils.getRecordKey(record, this.getRecordKeyFieldNames().get(0), this.isConsistentLogicalTimestampEnabled());
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return KeyGenUtils.getPartitionPath(record, this.getPartitionPathFields().get(0), this.hiveStylePartitioning, this.encodePartitionPath, this.isConsistentLogicalTimestampEnabled());
    }
}

