/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import org.apache.hudi.com.codahale.metrics.Counter;
import org.apache.hudi.com.codahale.metrics.Timer;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMetrics.class);
    public static final String TOTAL_PARTITIONS_WRITTEN_STR = "totalPartitionsWritten";
    public static final String TOTAL_FILES_INSERT_STR = "totalFilesInsert";
    public static final String TOTAL_FILES_UPDATE_STR = "totalFilesUpdate";
    public static final String TOTAL_RECORDS_WRITTEN_STR = "totalRecordsWritten";
    public static final String TOTAL_UPDATE_RECORDS_WRITTEN_STR = "totalUpdateRecordsWritten";
    public static final String TOTAL_INSERT_RECORDS_WRITTEN_STR = "totalInsertRecordsWritten";
    public static final String TOTAL_BYTES_WRITTEN_STR = "totalBytesWritten";
    public static final String TOTAL_SCAN_TIME_STR = "totalScanTime";
    public static final String TOTAL_CREATE_TIME_STR = "totalCreateTime";
    public static final String TOTAL_UPSERT_TIME_STR = "totalUpsertTime";
    public static final String TOTAL_COMPACTED_RECORDS_UPDATED_STR = "totalCompactedRecordsUpdated";
    public static final String TOTAL_LOG_FILES_COMPACTED_STR = "totalLogFilesCompacted";
    public static final String TOTAL_LOG_FILES_SIZE_STR = "totalLogFilesSize";
    public static final String TOTAL_RECORDS_DELETED = "totalRecordsDeleted";
    public static final String TOTAL_CORRUPTED_LOG_BLOCKS_STR = "totalCorruptedLogBlocks";
    public static final String TOTAL_ROLLBACK_LOG_BLOCKS_STR = "totalRollbackLogBlocks";
    private Metrics metrics;
    public String rollbackTimerName = null;
    public String cleanTimerName = null;
    public String commitTimerName = null;
    public String logCompactionTimerName = null;
    public String deltaCommitTimerName = null;
    public String replaceCommitTimerName = null;
    public String finalizeTimerName = null;
    public String compactionTimerName = null;
    public String indexTimerName = null;
    private String conflictResolutionTimerName = null;
    private String conflictResolutionSuccessCounterName = null;
    private String conflictResolutionFailureCounterName = null;
    private String compactionRequestedCounterName = null;
    private String compactionCompletedCounterName = null;
    private HoodieWriteConfig config;
    private String tableName;
    private Timer rollbackTimer = null;
    private Timer cleanTimer = null;
    private Timer commitTimer = null;
    private Timer deltaCommitTimer = null;
    private Timer finalizeTimer = null;
    private Timer compactionTimer = null;
    private Timer logCompactionTimer = null;
    private Timer clusteringTimer = null;
    private Timer indexTimer = null;
    private Timer conflictResolutionTimer = null;
    private Counter conflictResolutionSuccessCounter = null;
    private Counter conflictResolutionFailureCounter = null;
    private Counter compactionRequestedCounter = null;
    private Counter compactionCompletedCounter = null;

    public HoodieMetrics(HoodieWriteConfig config) {
        this.config = config;
        this.tableName = config.getTableName();
        if (config.isMetricsOn()) {
            this.metrics = Metrics.getInstance(config);
            this.rollbackTimerName = this.getMetricsName("timer", "rollback");
            this.cleanTimerName = this.getMetricsName("timer", "clean");
            this.commitTimerName = this.getMetricsName("timer", "commit");
            this.deltaCommitTimerName = this.getMetricsName("timer", "deltacommit");
            this.replaceCommitTimerName = this.getMetricsName("timer", "replacecommit");
            this.finalizeTimerName = this.getMetricsName("timer", "finalize");
            this.compactionTimerName = this.getMetricsName("timer", "compaction");
            this.logCompactionTimerName = this.getMetricsName("timer", "logcompaction");
            this.indexTimerName = this.getMetricsName("timer", "index");
            this.conflictResolutionTimerName = this.getMetricsName("timer", "conflict_resolution");
            this.conflictResolutionSuccessCounterName = this.getMetricsName("counter", "conflict_resolution.success");
            this.conflictResolutionFailureCounterName = this.getMetricsName("counter", "conflict_resolution.failure");
            this.compactionRequestedCounterName = this.getMetricsName("counter", "compaction.requested");
            this.compactionCompletedCounterName = this.getMetricsName("counter", "compaction.completed");
        }
    }

    private Timer createTimer(String name) {
        return this.config.isMetricsOn() ? this.metrics.getRegistry().timer(name) : null;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public Timer.Context getRollbackCtx() {
        if (this.config.isMetricsOn() && this.rollbackTimer == null) {
            this.rollbackTimer = this.createTimer(this.rollbackTimerName);
        }
        return this.rollbackTimer == null ? null : this.rollbackTimer.time();
    }

    public Timer.Context getCompactionCtx() {
        if (this.config.isMetricsOn() && this.compactionTimer == null) {
            this.compactionTimer = this.createTimer(this.commitTimerName);
        }
        return this.compactionTimer == null ? null : this.compactionTimer.time();
    }

    public Timer.Context getLogCompactionCtx() {
        if (this.config.isMetricsOn() && this.logCompactionTimer == null) {
            this.logCompactionTimer = this.createTimer(this.commitTimerName);
        }
        return this.logCompactionTimer == null ? null : this.logCompactionTimer.time();
    }

    public Timer.Context getClusteringCtx() {
        if (this.config.isMetricsOn() && this.clusteringTimer == null) {
            this.clusteringTimer = this.createTimer(this.replaceCommitTimerName);
        }
        return this.clusteringTimer == null ? null : this.clusteringTimer.time();
    }

    public Timer.Context getCleanCtx() {
        if (this.config.isMetricsOn() && this.cleanTimer == null) {
            this.cleanTimer = this.createTimer(this.cleanTimerName);
        }
        return this.cleanTimer == null ? null : this.cleanTimer.time();
    }

    public Timer.Context getCommitCtx() {
        if (this.config.isMetricsOn() && this.commitTimer == null) {
            this.commitTimer = this.createTimer(this.commitTimerName);
        }
        return this.commitTimer == null ? null : this.commitTimer.time();
    }

    public Timer.Context getFinalizeCtx() {
        if (this.config.isMetricsOn() && this.finalizeTimer == null) {
            this.finalizeTimer = this.createTimer(this.finalizeTimerName);
        }
        return this.finalizeTimer == null ? null : this.finalizeTimer.time();
    }

    public Timer.Context getDeltaCommitCtx() {
        if (this.config.isMetricsOn() && this.deltaCommitTimer == null) {
            this.deltaCommitTimer = this.createTimer(this.deltaCommitTimerName);
        }
        return this.deltaCommitTimer == null ? null : this.deltaCommitTimer.time();
    }

    public Timer.Context getIndexCtx() {
        if (this.config.isMetricsOn() && this.indexTimer == null) {
            this.indexTimer = this.createTimer(this.indexTimerName);
        }
        return this.indexTimer == null ? null : this.indexTimer.time();
    }

    public Timer.Context getConflictResolutionCtx() {
        if (this.config.isLockingMetricsEnabled() && this.conflictResolutionTimer == null) {
            this.conflictResolutionTimer = this.createTimer(this.conflictResolutionTimerName);
        }
        return this.conflictResolutionTimer == null ? null : this.conflictResolutionTimer.time();
    }

    public void updateMetricsForEmptyData(String actionType) {
        if (!this.config.isMetricsOn() || !this.config.getMetricsReporterType().equals((Object)MetricsReporterType.PROMETHEUS_PUSHGATEWAY)) {
            return;
        }
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_PARTITIONS_WRITTEN_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_FILES_INSERT_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_FILES_UPDATE_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_RECORDS_WRITTEN_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_UPDATE_RECORDS_WRITTEN_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_INSERT_RECORDS_WRITTEN_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_RECORDS_DELETED), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_BYTES_WRITTEN_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_SCAN_TIME_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_CREATE_TIME_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_UPSERT_TIME_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_COMPACTED_RECORDS_UPDATED_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_LOG_FILES_COMPACTED_STR), 0L);
        this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_LOG_FILES_SIZE_STR), 0L);
    }

    public void updateCommitMetrics(long commitEpochTimeInMs, long durationInMs, HoodieCommitMetadata metadata, String actionType) {
        this.updateCommitTimingMetrics(commitEpochTimeInMs, durationInMs, metadata, actionType);
        if (this.config.isMetricsOn()) {
            long totalPartitionsWritten = metadata.fetchTotalPartitionsWritten();
            long totalFilesInsert = metadata.fetchTotalFilesInsert();
            long totalFilesUpdate = metadata.fetchTotalFilesUpdated();
            long totalRecordsWritten = metadata.fetchTotalRecordsWritten();
            long totalUpdateRecordsWritten = metadata.fetchTotalUpdateRecordsWritten();
            long totalInsertRecordsWritten = metadata.fetchTotalInsertRecordsWritten();
            long totalRecordsDeleted = metadata.getTotalRecordsDeleted();
            long totalBytesWritten = metadata.fetchTotalBytesWritten();
            long totalTimeTakenByScanner = metadata.getTotalScanTime();
            long totalTimeTakenForInsert = metadata.getTotalCreateTime();
            long totalTimeTakenForUpsert = metadata.getTotalUpsertTime();
            long totalCompactedRecordsUpdated = metadata.getTotalCompactedRecordsUpdated();
            long totalLogFilesCompacted = metadata.getTotalLogFilesCompacted();
            long totalLogFilesSize = metadata.getTotalLogFilesSize();
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_PARTITIONS_WRITTEN_STR), totalPartitionsWritten);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_FILES_INSERT_STR), totalFilesInsert);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_FILES_UPDATE_STR), totalFilesUpdate);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_RECORDS_WRITTEN_STR), totalRecordsWritten);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_UPDATE_RECORDS_WRITTEN_STR), totalUpdateRecordsWritten);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_INSERT_RECORDS_WRITTEN_STR), totalInsertRecordsWritten);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_BYTES_WRITTEN_STR), totalBytesWritten);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_SCAN_TIME_STR), totalTimeTakenByScanner);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_CREATE_TIME_STR), totalTimeTakenForInsert);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_UPSERT_TIME_STR), totalTimeTakenForUpsert);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_COMPACTED_RECORDS_UPDATED_STR), totalCompactedRecordsUpdated);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_LOG_FILES_COMPACTED_STR), totalLogFilesCompacted);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_LOG_FILES_SIZE_STR), totalLogFilesSize);
            this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_RECORDS_DELETED), totalRecordsDeleted);
            if (this.config.isCompactionLogBlockMetricsOn()) {
                long totalCorruptedLogBlocks = metadata.getTotalCorruptLogBlocks();
                long totalRollbackLogBlocks = metadata.getTotalRollbackLogBlocks();
                this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_CORRUPTED_LOG_BLOCKS_STR), totalCorruptedLogBlocks);
                this.metrics.registerGauge(this.getMetricsName(actionType, TOTAL_ROLLBACK_LOG_BLOCKS_STR), totalRollbackLogBlocks);
            }
        }
    }

    private void updateCommitTimingMetrics(long commitEpochTimeInMs, long durationInMs, HoodieCommitMetadata metadata, String actionType) {
        if (this.config.isMetricsOn()) {
            Pair<Option<Long>, Option<Long>> eventTimePairMinMax = metadata.getMinAndMaxEventTime();
            if (eventTimePairMinMax.getLeft().isPresent()) {
                long commitLatencyInMs = commitEpochTimeInMs + durationInMs - eventTimePairMinMax.getLeft().get();
                this.metrics.registerGauge(this.getMetricsName(actionType, "commitLatencyInMs"), commitLatencyInMs);
            }
            if (eventTimePairMinMax.getRight().isPresent()) {
                long commitFreshnessInMs = commitEpochTimeInMs + durationInMs - eventTimePairMinMax.getRight().get();
                this.metrics.registerGauge(this.getMetricsName(actionType, "commitFreshnessInMs"), commitFreshnessInMs);
            }
            this.metrics.registerGauge(this.getMetricsName(actionType, "commitTime"), commitEpochTimeInMs);
            this.metrics.registerGauge(this.getMetricsName(actionType, "duration"), durationInMs);
        }
    }

    public void updateRollbackMetrics(long durationInMs, long numFilesDeleted) {
        if (this.config.isMetricsOn()) {
            LOG.info(String.format("Sending rollback metrics (duration=%d, numFilesDeleted=%d)", durationInMs, numFilesDeleted));
            this.metrics.registerGauge(this.getMetricsName("rollback", "duration"), durationInMs);
            this.metrics.registerGauge(this.getMetricsName("rollback", "numFilesDeleted"), numFilesDeleted);
        }
    }

    public void updateCleanMetrics(long durationInMs, int numFilesDeleted) {
        if (this.config.isMetricsOn()) {
            LOG.info(String.format("Sending clean metrics (duration=%d, numFilesDeleted=%d)", durationInMs, numFilesDeleted));
            this.metrics.registerGauge(this.getMetricsName("clean", "duration"), durationInMs);
            this.metrics.registerGauge(this.getMetricsName("clean", "numFilesDeleted"), numFilesDeleted);
        }
    }

    public void updateFinalizeWriteMetrics(long durationInMs, long numFilesFinalized) {
        if (this.config.isMetricsOn()) {
            LOG.info(String.format("Sending finalize write metrics (duration=%d, numFilesFinalized=%d)", durationInMs, numFilesFinalized));
            this.metrics.registerGauge(this.getMetricsName("finalize", "duration"), durationInMs);
            this.metrics.registerGauge(this.getMetricsName("finalize", "numFilesFinalized"), numFilesFinalized);
        }
    }

    public void updateIndexMetrics(String action, long durationInMs) {
        if (this.config.isMetricsOn()) {
            LOG.info(String.format("Sending index metrics (%s.duration, %d)", action, durationInMs));
            this.metrics.registerGauge(this.getMetricsName("index", String.format("%s.duration", action)), durationInMs);
        }
    }

    @VisibleForTesting
    public String getMetricsName(String action, String metric) {
        return this.config == null ? null : String.format("%s.%s.%s", this.config.getMetricReporterMetricsNamePrefix(), action, metric);
    }

    public void updateClusteringFileCreationMetrics(long durationInMs) {
        this.reportMetrics("replacecommit", "fileCreationTime", durationInMs);
    }

    public void reportMetrics(String commitAction, String metricName, long value) {
        this.metrics.registerGauge(this.getMetricsName(commitAction, metricName), value);
    }

    public long getDurationInMs(long ctxDuration) {
        return ctxDuration / 1000000L;
    }

    public void emitConflictResolutionSuccessful() {
        if (this.config.isLockingMetricsEnabled()) {
            LOG.info("Sending conflict resolution success metric");
            this.conflictResolutionSuccessCounter = this.getCounter(this.conflictResolutionSuccessCounter, this.conflictResolutionSuccessCounterName);
            this.conflictResolutionSuccessCounter.inc();
        }
    }

    public void emitConflictResolutionFailed() {
        if (this.config.isLockingMetricsEnabled()) {
            LOG.info("Sending conflict resolution failure metric");
            this.conflictResolutionFailureCounter = this.getCounter(this.conflictResolutionFailureCounter, this.conflictResolutionFailureCounterName);
            this.conflictResolutionFailureCounter.inc();
        }
    }

    public void emitCompactionRequested() {
        if (this.config.isMetricsOn()) {
            this.compactionRequestedCounter = this.getCounter(this.compactionRequestedCounter, this.compactionRequestedCounterName);
            this.compactionRequestedCounter.inc();
        }
    }

    public void emitCompactionCompleted() {
        if (this.config.isMetricsOn()) {
            this.compactionCompletedCounter = this.getCounter(this.compactionCompletedCounter, this.compactionCompletedCounterName);
            this.compactionCompletedCounter.inc();
        }
    }

    private Counter getCounter(Counter counter, String name) {
        if (counter == null) {
            return this.metrics.getRegistry().counter(name);
        }
        return counter;
    }
}

