/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.cloudwatch;

import java.util.concurrent.TimeUnit;
import org.apache.hudi.aws.cloudwatch.CloudWatchReporter;
import org.apache.hudi.com.codahale.metrics.MetricRegistry;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchMetricsReporter
extends MetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchMetricsReporter.class);
    private final MetricRegistry registry;
    private final HoodieWriteConfig config;
    private final CloudWatchReporter reporter;

    public CloudWatchMetricsReporter(HoodieWriteConfig config, MetricRegistry registry) {
        this.config = config;
        this.registry = registry;
        this.reporter = this.createCloudWatchReporter();
    }

    CloudWatchMetricsReporter(HoodieWriteConfig config, MetricRegistry registry, CloudWatchReporter reporter) {
        this.config = config;
        this.registry = registry;
        this.reporter = reporter;
    }

    private CloudWatchReporter createCloudWatchReporter() {
        return CloudWatchReporter.forRegistry(this.registry).prefixedWith(this.config.getCloudWatchMetricPrefix()).namespace(this.config.getCloudWatchMetricNamespace()).maxDatumsPerRequest(this.config.getCloudWatchMaxDatumsPerRequest()).build(this.config.getProps());
    }

    @Override
    public void start() {
        LOG.info("Starting CloudWatch Metrics Reporter.");
        this.reporter.start(this.config.getCloudWatchReportPeriodSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public void report() {
        this.reporter.report();
    }

    @Override
    public void stop() {
        LOG.info("Stopping CloudWatch Metrics Reporter.");
        this.reporter.stop();
    }
}

