/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.HTTPServer;
import java.net.InetSocketAddress;
import org.apache.hudi.com.codahale.metrics.MetricRegistry;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusReporter
extends MetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusReporter.class);
    private HTTPServer httpServer;
    private final DropwizardExports metricExports;
    private final CollectorRegistry collectorRegistry;

    public PrometheusReporter(HoodieWriteConfig config, MetricRegistry registry) {
        int serverPort = config.getPrometheusPort();
        this.collectorRegistry = new CollectorRegistry();
        this.metricExports = new DropwizardExports(registry);
        this.metricExports.register(this.collectorRegistry);
        try {
            this.httpServer = new HTTPServer(new InetSocketAddress(serverPort), this.collectorRegistry);
        }
        catch (Exception e) {
            String msg = "Could not start PrometheusReporter HTTP server on port " + serverPort;
            LOG.error(msg, (Throwable)e);
            throw new HoodieException(msg, e);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void report() {
    }

    @Override
    public void stop() {
        this.collectorRegistry.unregister(this.metricExports);
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
    }
}

