/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.RegionLocations;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncMetaRegionLocator;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncNonMetaRegionLocator;
import org.apache.hudi.org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.HashedWheelTimer;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.Timeout;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class AsyncRegionLocator {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncRegionLocator.class);
    private final HashedWheelTimer retryTimer;
    private final AsyncConnectionImpl conn;
    private final AsyncMetaRegionLocator metaRegionLocator;
    private final AsyncNonMetaRegionLocator nonMetaRegionLocator;

    AsyncRegionLocator(AsyncConnectionImpl conn, HashedWheelTimer retryTimer) {
        this.conn = conn;
        this.metaRegionLocator = new AsyncMetaRegionLocator(conn.registry);
        this.nonMetaRegionLocator = new AsyncNonMetaRegionLocator(conn);
        this.retryTimer = retryTimer;
    }

    private <T> CompletableFuture<T> withTimeout(CompletableFuture<T> future, long timeoutNs, Supplier<String> timeoutMsg) {
        if (future.isDone() || timeoutNs <= 0L) {
            return future;
        }
        Timeout timeoutTask = this.retryTimer.newTimeout(t -> {
            if (future.isDone()) {
                return;
            }
            future.completeExceptionally(new TimeoutIOException((String)timeoutMsg.get()));
        }, timeoutNs, TimeUnit.NANOSECONDS);
        FutureUtils.addListener(future, (loc, error) -> {
            if (error != null && error.getClass() != TimeoutIOException.class) {
                timeoutTask.cancel();
            }
        });
        return future;
    }

    private boolean isMeta(TableName tableName) {
        return TableName.isMetaTableName(tableName);
    }

    CompletableFuture<RegionLocations> getRegionLocations(TableName tableName, byte[] row, RegionLocateType type, boolean reload, long timeoutNs) {
        CompletableFuture<RegionLocations> future = this.isMeta(tableName) ? this.metaRegionLocator.getRegionLocations(0, reload) : this.nonMetaRegionLocator.getRegionLocations(tableName, row, 0, type, reload);
        return this.withTimeout(future, timeoutNs, () -> "Timeout(" + TimeUnit.NANOSECONDS.toMillis(timeoutNs) + "ms) waiting for region locations for " + tableName + ", row='" + Bytes.toStringBinary(row) + "'");
    }

    CompletableFuture<HRegionLocation> getRegionLocation(TableName tableName, byte[] row, int replicaId, RegionLocateType type, boolean reload, long timeoutNs) {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture<RegionLocations> locsFuture = this.isMeta(tableName) ? this.metaRegionLocator.getRegionLocations(replicaId, reload) : this.nonMetaRegionLocator.getRegionLocations(tableName, row, replicaId, type, reload);
        FutureUtils.addListener(locsFuture, (locs, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            HRegionLocation loc = locs.getRegionLocation(replicaId);
            if (loc == null) {
                future.completeExceptionally(new RegionOfflineException("No location for " + tableName + ", row='" + Bytes.toStringBinary(row) + "', locateType=" + (Object)((Object)type) + ", replicaId=" + replicaId));
            } else if (loc.getServerName() == null) {
                future.completeExceptionally(new RegionOfflineException("No server address listed for region '" + loc.getRegion().getRegionNameAsString() + ", row='" + Bytes.toStringBinary(row) + "', locateType=" + (Object)((Object)type) + ", replicaId=" + replicaId));
            } else {
                future.complete(loc);
            }
        });
        return this.withTimeout(future, timeoutNs, () -> "Timeout(" + TimeUnit.NANOSECONDS.toMillis(timeoutNs) + "ms) waiting for region location for " + tableName + ", row='" + Bytes.toStringBinary(row) + "', replicaId=" + replicaId);
    }

    CompletableFuture<HRegionLocation> getRegionLocation(TableName tableName, byte[] row, int replicaId, RegionLocateType type, long timeoutNs) {
        return this.getRegionLocation(tableName, row, replicaId, type, false, timeoutNs);
    }

    CompletableFuture<HRegionLocation> getRegionLocation(TableName tableName, byte[] row, RegionLocateType type, boolean reload, long timeoutNs) {
        return this.getRegionLocation(tableName, row, 0, type, reload, timeoutNs);
    }

    CompletableFuture<HRegionLocation> getRegionLocation(TableName tableName, byte[] row, RegionLocateType type, long timeoutNs) {
        return this.getRegionLocation(tableName, row, type, false, timeoutNs);
    }

    void updateCachedLocationOnError(HRegionLocation loc, Throwable exception) {
        if (loc.getRegion().isMetaRegion()) {
            this.metaRegionLocator.updateCachedLocationOnError(loc, exception);
        } else {
            this.nonMetaRegionLocator.updateCachedLocationOnError(loc, exception);
        }
    }

    void clearCache(TableName tableName) {
        LOG.debug("Clear meta cache for {}", (Object)tableName);
        if (tableName.equals(TableName.META_TABLE_NAME)) {
            this.metaRegionLocator.clearCache();
        } else {
            this.nonMetaRegionLocator.clearCache(tableName);
        }
    }

    void clearCache(ServerName serverName) {
        LOG.debug("Clear meta cache for {}", (Object)serverName);
        this.metaRegionLocator.clearCache(serverName);
        this.nonMetaRegionLocator.clearCache(serverName);
        this.conn.getConnectionMetrics().ifPresent(MetricsConnection::incrMetaCacheNumClearServer);
    }

    void clearCache() {
        this.metaRegionLocator.clearCache();
        this.nonMetaRegionLocator.clearCache();
    }

    AsyncNonMetaRegionLocator getNonMetaRegionLocator() {
        return this.nonMetaRegionLocator;
    }
}

