/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.MetaCellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.CellSet;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.wal.EntryBuffers;
import org.apache.hudi.org.apache.hadoop.hbase.wal.OutputSink;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WAL;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALSplitUtil;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BoundedRecoveredHFilesOutputSink
extends OutputSink {
    private static final Logger LOG = LoggerFactory.getLogger(BoundedRecoveredHFilesOutputSink.class);
    private final WALSplitter walSplitter;
    private ConcurrentMap<String, Long> regionEditsWrittenMap = new ConcurrentHashMap<String, Long>();
    private final AtomicInteger openingWritersNum = new AtomicInteger(0);

    public BoundedRecoveredHFilesOutputSink(WALSplitter walSplitter, WALSplitter.PipelineController controller, EntryBuffers entryBuffers, int numWriters) {
        super(controller, entryBuffers, numWriters);
        this.walSplitter = walSplitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(EntryBuffers.RegionEntryBuffer buffer) throws IOException {
        HashMap<String, CellSet> familyCells = new HashMap<String, CellSet>();
        HashMap<String, Long> familySeqIds = new HashMap<String, Long>();
        boolean isMetaTable = buffer.tableName.equals(TableName.META_TABLE_NAME);
        for (WAL.Entry entry : buffer.entries) {
            long seqId = entry.getKey().getSequenceId();
            ArrayList<Cell> cells = entry.getEdit().getCells();
            for (Cell cell : cells) {
                if (CellUtil.matchingFamily(cell, WALEdit.METAFAMILY)) continue;
                PrivateCellUtil.setSequenceId(cell, seqId);
                String familyName = Bytes.toString(CellUtil.cloneFamily(cell));
                familyCells.computeIfAbsent(familyName, key -> new CellSet(isMetaTable ? MetaCellComparator.META_COMPARATOR : CellComparatorImpl.COMPARATOR)).add(cell);
                familySeqIds.compute(familyName, (k, v) -> v == null ? seqId : Math.max(v, seqId));
            }
        }
        String regionName = Bytes.toString(buffer.encodedRegionName);
        for (Map.Entry cellsEntry : familyCells.entrySet()) {
            String familyName = (String)cellsEntry.getKey();
            StoreFileWriter writer = this.createRecoveredHFileWriter(buffer.tableName, regionName, (Long)familySeqIds.get(familyName), familyName, isMetaTable);
            LOG.trace("Created {}", (Object)writer.getPath());
            this.openingWritersNum.incrementAndGet();
            try {
                for (Cell cell : (CellSet)cellsEntry.getValue()) {
                    writer.append(cell);
                }
                writer.appendMetadata((Long)familySeqIds.get(familyName), false);
                this.regionEditsWrittenMap.compute(Bytes.toString(buffer.encodedRegionName), (k, v) -> v == null ? (long)buffer.entries.size() : v + (long)buffer.entries.size());
                this.splits.add(writer.getPath());
                this.openingWritersNum.decrementAndGet();
            }
            finally {
                writer.close();
                LOG.trace("Closed {}, edits={}", (Object)writer.getPath(), (Object)familyCells.size());
            }
        }
    }

    @Override
    public List<Path> close() throws IOException {
        boolean isSuccessful = true;
        try {
            isSuccessful = this.finishWriterThreads(false);
        }
        finally {
            isSuccessful &= this.writeRemainingEntryBuffers();
        }
        return isSuccessful ? this.splits : null;
    }

    private boolean writeRemainingEntryBuffers() throws IOException {
        for (EntryBuffers.RegionEntryBuffer buffer : this.entryBuffers.buffers.values()) {
            this.closeCompletionService.submit(() -> {
                this.append(buffer);
                return null;
            });
        }
        boolean progressFailed = false;
        try {
            int n = this.entryBuffers.buffers.size();
            for (int i = 0; i < n; ++i) {
                Future future = this.closeCompletionService.take();
                future.get();
                if (progressFailed || this.reporter == null || this.reporter.progress()) continue;
                progressFailed = true;
            }
        }
        catch (InterruptedException e) {
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(e);
            throw iie;
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        finally {
            this.closeThreadPool.shutdownNow();
        }
        return !progressFailed;
    }

    @Override
    public Map<String, Long> getOutputCounts() {
        return this.regionEditsWrittenMap;
    }

    @Override
    public int getNumberOfRecoveredRegions() {
        return this.regionEditsWrittenMap.size();
    }

    @Override
    public int getNumOpenWriters() {
        return this.openingWritersNum.get();
    }

    @Override
    public boolean keepRegionEvent(WAL.Entry entry) {
        return false;
    }

    private StoreFileWriter createRecoveredHFileWriter(TableName tableName, String regionName, long seqId, String familyName, boolean isMetaTable) throws IOException {
        Path outputDir = WALSplitUtil.tryCreateRecoveredHFilesDir(this.walSplitter.rootFS, this.walSplitter.conf, tableName, regionName, familyName);
        StoreFileWriter.Builder writerBuilder = new StoreFileWriter.Builder(this.walSplitter.conf, CacheConfig.DISABLED, this.walSplitter.rootFS).withOutputDir(outputDir);
        HFileContext hFileContext = new HFileContextBuilder().withChecksumType(StoreUtils.getChecksumType(this.walSplitter.conf)).withBytesPerCheckSum(StoreUtils.getBytesPerChecksum(this.walSplitter.conf)).withCellComparator(isMetaTable ? MetaCellComparator.META_COMPARATOR : CellComparatorImpl.COMPARATOR).build();
        return writerBuilder.withFileContext(hFileContext).build();
    }
}

