/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.client.clustering.plan.strategy.FlinkConsistentBucketClusteringPlanStrategy;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.OptionsResolver;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieFlinkTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteringUtil.class);

    public static void validateClusteringScheduling(Configuration conf) {
        if (OptionsResolver.isBucketIndexType(conf)) {
            HoodieIndex.BucketIndexEngineType bucketIndexEngineType = OptionsResolver.getBucketEngineType(conf);
            switch (bucketIndexEngineType) {
                case SIMPLE: {
                    throw new HoodieNotSupportedException("Clustering is not supported for simple bucket index.");
                }
                case CONSISTENT_HASHING: {
                    String clusteringPlanStrategyClass = conf.getString(FlinkOptions.CLUSTERING_PLAN_STRATEGY_CLASS, OptionsResolver.getDefaultPlanStrategyClassName(conf));
                    if (clusteringPlanStrategyClass.equalsIgnoreCase(FlinkConsistentBucketClusteringPlanStrategy.class.getName())) break;
                    throw new HoodieNotSupportedException("CLUSTERING_PLAN_STRATEGY_CLASS should be set to " + FlinkConsistentBucketClusteringPlanStrategy.class.getName() + " in order to work with Consistent Hashing Bucket Index.");
                }
                default: {
                    throw new HoodieNotSupportedException("Unknown bucket index engine type: " + (Object)((Object)bucketIndexEngineType));
                }
            }
        }
    }

    public static void scheduleClustering(Configuration conf, HoodieFlinkWriteClient writeClient, boolean committed) {
        ClusteringUtil.validateClusteringScheduling(conf);
        if (committed) {
            writeClient.scheduleClustering(Option.empty());
        }
    }

    public static void rollbackClustering(HoodieFlinkTable<?> table, HoodieFlinkWriteClient writeClient) {
        List<HoodieInstant> inflightInstants = ClusteringUtils.getPendingClusteringInstantTimes(table.getMetaClient()).stream().filter(instant -> instant.getState() == HoodieInstant.State.INFLIGHT).collect(Collectors.toList());
        inflightInstants.forEach(inflightInstant -> {
            LOG.info("Rollback the inflight clustering instant: " + inflightInstant + " for failover");
            table.rollbackInflightClustering((HoodieInstant)inflightInstant, commitToRollback -> writeClient.getTableServiceClient().getPendingRollbackInfo(table.getMetaClient(), (String)commitToRollback, false));
            table.getMetaClient().reloadActiveTimeline();
        });
    }

    public static void rollbackClustering(HoodieFlinkTable<?> table, HoodieFlinkWriteClient<?> writeClient, String instantTime) {
        HoodieInstant inflightInstant = HoodieTimeline.getReplaceCommitInflightInstant(instantTime);
        if (table.getMetaClient().reloadActiveTimeline().filterPendingReplaceTimeline().containsInstant(inflightInstant)) {
            LOG.warn("Rollback failed clustering instant: [" + instantTime + "]");
            table.rollbackInflightClustering(inflightInstant, commitToRollback -> writeClient.getTableServiceClient().getPendingRollbackInfo(table.getMetaClient(), (String)commitToRollback, false));
        }
    }

    public static boolean isClusteringInstant(HoodieInstant instant, HoodieTimeline timeline) {
        if (!instant.getAction().equals("replacecommit")) {
            return false;
        }
        try {
            return TimelineUtils.getCommitMetadata(instant, timeline).getOperationType().equals((Object)WriteOperationType.CLUSTER);
        }
        catch (IOException e) {
            throw new HoodieException("Resolve replace commit metadata error for instant: " + instant, e);
        }
    }
}

