/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Properties;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;

public abstract class BaseAvroPayload
implements Serializable {
    protected final byte[] recordBytes;
    protected final Comparable orderingVal;
    protected final boolean isDeletedRecord;

    public BaseAvroPayload(GenericRecord record, Comparable orderingVal) {
        this.recordBytes = record != null ? HoodieAvroUtils.avroToBytes(record) : new byte[]{};
        this.orderingVal = orderingVal;
        boolean bl = this.isDeletedRecord = record == null || this.isDeleteRecord(record);
        if (orderingVal == null) {
            throw new HoodieException("Ordering value is null for record: " + record);
        }
    }

    public Comparable getOrderingVal() {
        return this.orderingVal;
    }

    public boolean isDeleted(Schema schema, Properties props) {
        return this.isDeletedRecord;
    }

    public boolean canProduceSentinel() {
        return false;
    }

    protected boolean isDeleteRecord(GenericRecord genericRecord) {
        String isDeleteKey = "_hoodie_is_deleted";
        if (genericRecord.getSchema().getField("_hoodie_is_deleted") == null) {
            return false;
        }
        Object deleteMarker = genericRecord.get("_hoodie_is_deleted");
        return deleteMarker instanceof Boolean && (Boolean)deleteMarker != false;
    }
}

