/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ValidationUtils;

public abstract class InstantRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String startInstant;
    protected final String endInstant;

    public InstantRange(String startInstant, String endInstant) {
        this.startInstant = startInstant;
        this.endInstant = endInstant;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStartInstant() {
        return this.startInstant;
    }

    public String getEndInstant() {
        return this.endInstant;
    }

    public abstract boolean isInRange(String var1);

    public static class Builder {
        private String startInstant;
        private String endInstant;
        private RangeType rangeType;
        private boolean nullableBoundary = false;
        private Set<String> explicitInstants;

        private Builder() {
        }

        public Builder startInstant(String startInstant) {
            this.startInstant = startInstant;
            return this;
        }

        public Builder endInstant(String endInstant) {
            this.endInstant = endInstant;
            return this;
        }

        public Builder rangeType(RangeType rangeType) {
            this.rangeType = rangeType;
            return this;
        }

        public Builder nullableBoundary(boolean nullable) {
            this.nullableBoundary = nullable;
            return this;
        }

        public Builder explicitInstants(Set<String> instants) {
            this.explicitInstants = instants;
            return this;
        }

        public InstantRange build() {
            ValidationUtils.checkState(this.rangeType != null, "Range type is required");
            switch (this.rangeType) {
                case OPEN_CLOSE: {
                    return this.nullableBoundary ? new OpenCloseRangeNullableBoundary(this.startInstant, this.endInstant) : new OpenCloseRange(this.startInstant, this.endInstant);
                }
                case CLOSE_CLOSE: {
                    return this.nullableBoundary ? new CloseCloseRangeNullableBoundary(this.startInstant, this.endInstant) : new CloseCloseRange(this.startInstant, this.endInstant);
                }
                case EXPLICIT_MATCH: {
                    return new ExplicitMatchRange(this.explicitInstants);
                }
            }
            throw new AssertionError();
        }
    }

    private static class ExplicitMatchRange
    extends InstantRange {
        Set<String> instants;

        public ExplicitMatchRange(Set<String> instants) {
            super(Collections.min(instants), Collections.max(instants));
            this.instants = instants;
        }

        @Override
        public boolean isInRange(String instant) {
            return this.instants.contains(instant);
        }
    }

    private static class CloseCloseRangeNullableBoundary
    extends InstantRange {
        public CloseCloseRangeNullableBoundary(String startInstant, String endInstant) {
            super(startInstant, endInstant);
            ValidationUtils.checkArgument(startInstant != null || endInstant != null, "Start and end instants can not both be null");
        }

        @Override
        public boolean isInRange(String instant) {
            if (this.startInstant == null) {
                return HoodieTimeline.compareTimestamps(instant, HoodieTimeline.LESSER_THAN_OR_EQUALS, this.endInstant);
            }
            if (this.endInstant == null) {
                return HoodieTimeline.compareTimestamps(instant, HoodieTimeline.GREATER_THAN_OR_EQUALS, this.startInstant);
            }
            return HoodieTimeline.compareTimestamps(instant, HoodieTimeline.GREATER_THAN_OR_EQUALS, this.startInstant) && HoodieTimeline.compareTimestamps(instant, HoodieTimeline.LESSER_THAN_OR_EQUALS, this.endInstant);
        }
    }

    private static class CloseCloseRange
    extends InstantRange {
        public CloseCloseRange(String startInstant, String endInstant) {
            super(Objects.requireNonNull(startInstant), endInstant);
        }

        @Override
        public boolean isInRange(String instant) {
            return HoodieTimeline.compareTimestamps(instant, HoodieTimeline.GREATER_THAN_OR_EQUALS, this.startInstant);
        }
    }

    private static class OpenCloseRangeNullableBoundary
    extends InstantRange {
        public OpenCloseRangeNullableBoundary(String startInstant, String endInstant) {
            super(startInstant, endInstant);
            ValidationUtils.checkArgument(startInstant != null || endInstant != null, "Start and end instants can not both be null");
        }

        @Override
        public boolean isInRange(String instant) {
            if (this.startInstant == null) {
                return HoodieTimeline.compareTimestamps(instant, HoodieTimeline.LESSER_THAN_OR_EQUALS, this.endInstant);
            }
            if (this.endInstant == null) {
                return HoodieTimeline.compareTimestamps(instant, HoodieTimeline.GREATER_THAN, this.startInstant);
            }
            return HoodieTimeline.compareTimestamps(instant, HoodieTimeline.GREATER_THAN, this.startInstant) && HoodieTimeline.compareTimestamps(instant, HoodieTimeline.LESSER_THAN_OR_EQUALS, this.endInstant);
        }
    }

    private static class OpenCloseRange
    extends InstantRange {
        public OpenCloseRange(String startInstant, String endInstant) {
            super(Objects.requireNonNull(startInstant), endInstant);
        }

        @Override
        public boolean isInRange(String instant) {
            return HoodieTimeline.compareTimestamps(instant, HoodieTimeline.GREATER_THAN, this.startInstant);
        }
    }

    public static enum RangeType {
        OPEN_CLOSE,
        CLOSE_CLOSE,
        EXPLICIT_MATCH;

    }
}

