/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFileWriteCallback;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.HoodieIOHandle;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieWriteHandle<T, I, K, O>
extends HoodieIOHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieWriteHandle.class);
    protected final Schema writeSchema;
    protected final Schema writeSchemaWithMetaFields;
    protected final HoodieRecordMerger recordMerger;
    protected HoodieTimer timer;
    protected WriteStatus writeStatus;
    protected HoodieRecordLocation newRecordLocation;
    protected final String partitionPath;
    protected final String fileId;
    protected final String writeToken;
    protected final TaskContextSupplier taskContextSupplier;
    protected final boolean schemaOnReadEnabled;
    private boolean closed = false;

    public HoodieWriteHandle(HoodieWriteConfig config, String instantTime, String partitionPath, String fileId, HoodieTable<T, I, K, O> hoodieTable, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, partitionPath, fileId, hoodieTable, Option.empty(), taskContextSupplier);
    }

    protected HoodieWriteHandle(HoodieWriteConfig config, String instantTime, String partitionPath, String fileId, HoodieTable<T, I, K, O> hoodieTable, Option<Schema> overriddenSchema, TaskContextSupplier taskContextSupplier) {
        super(config, Option.of(instantTime), hoodieTable);
        this.partitionPath = partitionPath;
        this.fileId = fileId;
        this.writeSchema = overriddenSchema.orElseGet(() -> HoodieWriteHandle.getWriteSchema(config));
        this.writeSchemaWithMetaFields = HoodieAvroUtils.addMetadataFields(this.writeSchema, config.allowOperationMetadataField());
        this.timer = HoodieTimer.start();
        this.newRecordLocation = new HoodieRecordLocation(instantTime, fileId);
        this.taskContextSupplier = taskContextSupplier;
        this.writeToken = this.makeWriteToken();
        this.schemaOnReadEnabled = !StringUtils.isNullOrEmpty(hoodieTable.getConfig().getInternalSchema());
        this.recordMerger = config.getRecordMerger();
        this.writeStatus = (WriteStatus)ReflectionUtils.loadClass(config.getWriteStatusClassName(), hoodieTable.shouldTrackSuccessRecords(), config.getWriteStatusFailureFraction());
    }

    private String makeWriteToken() {
        return FSUtils.makeWriteToken(this.getPartitionId(), this.getStageId(), this.getAttemptId());
    }

    public StoragePath makeNewPath(String partitionPath) {
        StoragePath path = FSUtils.constructAbsolutePath(this.config.getBasePath(), partitionPath);
        try {
            if (!this.storage.exists(path)) {
                this.storage.createDirectory(path);
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to make dir " + path, e);
        }
        return new StoragePath(path, FSUtils.makeBaseFileName(this.instantTime, this.writeToken, this.fileId, this.hoodieTable.getMetaClient().getTableConfig().getBaseFileFormat().getFileExtension()));
    }

    protected StoragePath makeNewFilePath(String partitionPath, String fileName) {
        String relativePath = new StoragePath((partitionPath.isEmpty() ? "" : partitionPath + "/") + fileName).toString();
        return new StoragePath(this.config.getBasePath(), relativePath);
    }

    protected void createMarkerFile(String partitionPath, String dataFileName) {
        WriteMarkersFactory.get(this.config.getMarkersType(), this.hoodieTable, this.instantTime).create(partitionPath, dataFileName, this.getIOType(), this.config, this.fileId, this.hoodieTable.getMetaClient().getActiveTimeline());
    }

    public Schema getWriterSchemaWithMetaFields() {
        return this.writeSchemaWithMetaFields;
    }

    public Schema getWriterSchema() {
        return this.writeSchema;
    }

    public boolean canWrite(HoodieRecord record) {
        return false;
    }

    boolean layoutControlsNumFiles() {
        return this.hoodieTable.getStorageLayout().determinesNumFileGroups();
    }

    protected void doWrite(HoodieRecord record, Schema schema, TypedProperties props) {
    }

    public void write(HoodieRecord record, Schema schema, TypedProperties props) {
        this.doWrite(record, schema, props);
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void markClosed() {
        this.closed = true;
    }

    public abstract List<WriteStatus> close();

    public List<WriteStatus> getWriteStatuses() {
        return Collections.singletonList(this.writeStatus);
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public abstract IOType getIOType();

    @Override
    public HoodieStorage getStorage() {
        return this.hoodieTable.getStorage();
    }

    public HoodieWriteConfig getConfig() {
        return this.config;
    }

    public HoodieTableMetaClient getHoodieTableMetaClient() {
        return this.hoodieTable.getMetaClient();
    }

    public String getFileId() {
        return this.fileId;
    }

    protected int getPartitionId() {
        return this.taskContextSupplier.getPartitionIdSupplier().get();
    }

    protected int getStageId() {
        return this.taskContextSupplier.getStageIdSupplier().get();
    }

    protected long getAttemptId() {
        return this.taskContextSupplier.getAttemptIdSupplier().get();
    }

    private static Schema getWriteSchema(HoodieWriteConfig config) {
        return new Schema.Parser().parse(config.getWriteSchema());
    }

    protected HoodieLogFormat.Writer createLogWriter(Option<FileSlice> fileSlice, String baseCommitTime) throws IOException {
        return this.createLogWriter(fileSlice, baseCommitTime, null);
    }

    protected HoodieLogFormat.Writer createLogWriter(Option<FileSlice> fileSlice, String baseCommitTime, String suffix) throws IOException {
        Option<HoodieLogFile> latestLogFile = fileSlice.isPresent() ? fileSlice.get().getLatestLogFile() : Option.empty();
        return HoodieLogFormat.newWriterBuilder().onParentPath(FSUtils.constructAbsolutePath(this.hoodieTable.getMetaClient().getBasePath(), this.partitionPath)).withFileId(this.fileId).overBaseCommit(baseCommitTime).withLogVersion(latestLogFile.map(HoodieLogFile::getLogVersion).orElse(HoodieLogFile.LOGFILE_BASE_VERSION)).withFileSize(latestLogFile.map(HoodieLogFile::getFileSize).orElse(0L)).withSizeThreshold(this.config.getLogFileMaxSize()).withStorage(this.storage).withRolloverLogWriteToken(this.writeToken).withLogWriteToken(latestLogFile.map(HoodieLogFile::getLogWriteToken).orElse(this.writeToken)).withSuffix(suffix).withLogWriteCallback(this.getLogWriteCallback()).withFileExtension(".log").build();
    }

    protected HoodieLogFileWriteCallback getLogWriteCallback() {
        return new AppendLogWriteCallback();
    }

    protected HoodieLogFormat.Writer createLogWriter(String baseCommitTime, String fileSuffix) {
        try {
            return this.createLogWriter(Option.empty(), baseCommitTime, fileSuffix);
        }
        catch (IOException e) {
            throw new HoodieException("Creating logger writer with fileId: " + this.fileId + ", base commit time: " + baseCommitTime + ", file suffix: " + fileSuffix + " error");
        }
    }

    protected static Option<IndexedRecord> toAvroRecord(HoodieRecord record, Schema writerSchema, TypedProperties props) {
        try {
            return record.toIndexedRecord(writerSchema, props).map(HoodieRecord::getData);
        }
        catch (IOException e) {
            LOG.error("Fail to get indexRecord from " + record, (Throwable)e);
            return Option.empty();
        }
    }

    protected class AppendLogWriteCallback
    implements HoodieLogFileWriteCallback {
        protected AppendLogWriteCallback() {
        }

        @Override
        public boolean preLogFileOpen(HoodieLogFile logFileToAppend) {
            return this.createAppendMarker(logFileToAppend);
        }

        @Override
        public boolean preLogFileCreate(HoodieLogFile logFileToCreate) {
            return this.createAppendMarker(logFileToCreate);
        }

        private boolean createAppendMarker(HoodieLogFile logFileToAppend) {
            WriteMarkers writeMarkers = WriteMarkersFactory.get(HoodieWriteHandle.this.config.getMarkersType(), HoodieWriteHandle.this.hoodieTable, HoodieWriteHandle.this.instantTime);
            return writeMarkers.createIfNotExists(HoodieWriteHandle.this.partitionPath, logFileToAppend.getFileName(), IOType.APPEND, HoodieWriteHandle.this.config, HoodieWriteHandle.this.fileId, HoodieWriteHandle.this.hoodieTable.getMetaClient().getActiveTimeline()).isPresent();
        }
    }
}

