/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.util;

import java.util.Locale;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.metaserver.thrift.TAction;
import org.apache.hudi.metaserver.thrift.THoodieInstant;
import org.apache.hudi.metaserver.thrift.TState;

public class EntityConversions {
    public static THoodieInstant toTHoodieInstant(HoodieInstant instant) {
        return new THoodieInstant(instant.getTimestamp(), EntityConversions.toTAction(instant.getAction()), EntityConversions.toTState(instant.getState()));
    }

    public static HoodieInstant fromTHoodieInstant(THoodieInstant instant) {
        return new HoodieInstant(EntityConversions.fromTState(instant.getState()), EntityConversions.fromTAction(instant.getAction()), instant.getTimestamp());
    }

    public static TAction toTAction(String action) {
        switch (action) {
            case "commit": {
                return TAction.COMMIT;
            }
            case "deltacommit": {
                return TAction.DELTACOMMIT;
            }
            case "clean": {
                return TAction.CLEAN;
            }
            case "rollback": {
                return TAction.ROLLBACK;
            }
            case "savepoint": {
                return TAction.SAVEPOINT;
            }
            case "replacecommit": {
                return TAction.REPLACECOMMIT;
            }
            case "compaction": {
                return TAction.COMPACTION;
            }
            case "restore": {
                return TAction.RESTORE;
            }
        }
        throw new IllegalArgumentException("Unknown action: " + action);
    }

    public static TState toTState(HoodieInstant.State state) {
        switch (state) {
            case COMPLETED: {
                return TState.COMPLETED;
            }
            case INFLIGHT: {
                return TState.INFLIGHT;
            }
            case REQUESTED: {
                return TState.REQUESTED;
            }
            case NIL: {
                return TState.NIL;
            }
        }
        throw new IllegalArgumentException("Unknown state: " + state.name());
    }

    public static String fromTAction(TAction action) {
        switch (action) {
            case COMMIT: 
            case DELTACOMMIT: 
            case CLEAN: 
            case ROLLBACK: 
            case SAVEPOINT: 
            case REPLACECOMMIT: 
            case COMPACTION: 
            case RESTORE: {
                return action.name().toLowerCase(Locale.ROOT);
            }
        }
        throw new IllegalArgumentException("Unknown action: " + (Object)((Object)action));
    }

    public static HoodieInstant.State fromTState(TState state) {
        switch (state) {
            case COMPLETED: {
                return HoodieInstant.State.COMPLETED;
            }
            case INFLIGHT: {
                return HoodieInstant.State.INFLIGHT;
            }
            case REQUESTED: {
                return HoodieInstant.State.REQUESTED;
            }
            case NIL: {
                return HoodieInstant.State.NIL;
            }
        }
        throw new IllegalArgumentException("Unknown state: " + state.name());
    }
}

