/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow.vector;

import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.columnar.ColumnarMapData;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.MapColumnVector;
import org.apache.flink.table.data.columnar.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;

public class HeapMapColumnVector
extends AbstractHeapVector
implements WritableColumnVector,
MapColumnVector {
    private long[] offsets;
    private long[] lengths;
    private int size = 0;
    private ColumnVector keys;
    private ColumnVector values;

    public HeapMapColumnVector(int len, ColumnVector keys, ColumnVector values) {
        super(len);
        this.offsets = new long[len];
        this.lengths = new long[len];
        this.keys = keys;
        this.values = values;
    }

    public void setOffsets(long[] offsets) {
        this.offsets = offsets;
    }

    public void setLengths(long[] lengths) {
        this.lengths = lengths;
    }

    public void setKeys(ColumnVector keys) {
        this.keys = keys;
    }

    public void setValues(ColumnVector values) {
        this.values = values;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public MapData getMap(int i) {
        long offset = this.offsets[i];
        long length = this.lengths[i];
        return new ColumnarMapData(this.keys, this.values, (int)offset, (int)length);
    }
}

