/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.processors;

import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import org.apache.hudi.avro.AvroLogicalTypeEnum;
import org.apache.hudi.avro.processors.Parser;
import org.apache.hudi.avro.processors.TimeLogicalTypeProcessor;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.org.apache.avro.Schema;

public class LocalTimestampMilliLogicalTypeProcessor
extends TimeLogicalTypeProcessor {
    public LocalTimestampMilliLogicalTypeProcessor() {
        super(AvroLogicalTypeEnum.LOCAL_TIMESTAMP_MILLIS);
    }

    @Override
    public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
        return this.convertCommon(new Parser.LongParser(){

            @Override
            public Pair<Boolean, Object> handleStringValue(String value) {
                if (!LocalTimestampMilliLogicalTypeProcessor.this.isWellFormedDateTime(value)) {
                    return Pair.of(false, null);
                }
                Pair<Boolean, LocalDateTime> result = LocalTimestampMilliLogicalTypeProcessor.this.convertToLocalDateTime(value);
                if (!result.getLeft().booleanValue()) {
                    return Pair.of(false, null);
                }
                LocalDateTime time = result.getRight();
                long diffInMillis = TimeLogicalTypeProcessor.LOCAL_UNIX_EPOCH.until(time, ChronoField.MILLI_OF_SECOND.getBaseUnit());
                return Pair.of(true, diffInMillis);
            }
        }, value, schema);
    }
}

