/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import java.io.IOException;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;

public class CommitMetadataSerDeV1
implements CommitMetadataSerDe {
    @Override
    public <T> T deserialize(HoodieInstant instant, byte[] bytes, Class<T> clazz) throws IOException {
        try {
            if (bytes.length == 0) {
                return clazz.newInstance();
            }
            return CommitMetadataSerDeV1.fromJsonString(StringUtils.fromUTF8Bytes(bytes), clazz);
        }
        catch (Exception e) {
            throw new IOException("unable to read commit metadata for instant " + instant + " bytes length: " + bytes.length, e);
        }
    }

    public static <T> T fromJsonString(String jsonStr, Class<T> clazz) throws Exception {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return clazz.newInstance();
        }
        return JsonUtils.getObjectMapper().readValue(jsonStr, clazz);
    }

    @Override
    public Option<byte[]> serialize(HoodieCommitMetadata commitMetadata) throws IOException {
        return Option.ofNullable(commitMetadata.toJsonString().getBytes());
    }
}

