/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;

public class HFileBlockReader {
    private final HFileContext context;
    private final long streamStartOffset;
    private final SeekableDataInputStream stream;
    private final byte[] byteBuff;
    private int offset;
    private boolean isReadFully = false;

    public HFileBlockReader(HFileContext context, SeekableDataInputStream stream, long startOffset, long endOffset) {
        this.context = context;
        this.stream = stream;
        this.streamStartOffset = startOffset;
        this.offset = 0;
        long length = endOffset - startOffset;
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The range of bytes is too large or invalid: [" + startOffset + ", " + endOffset + "], length=" + length);
        }
        this.byteBuff = new byte[(int)length];
    }

    public HFileBlock nextBlock(HFileBlockType expectedBlockType) throws IOException {
        if (this.offset >= this.byteBuff.length) {
            throw new EOFException("No more data to read");
        }
        if (!this.isReadFully) {
            this.stream.seek(this.streamStartOffset);
            this.stream.readFully(this.byteBuff);
            this.isReadFully = true;
        }
        HFileBlock block = HFileBlock.parse(this.context, this.byteBuff, this.offset);
        block.unpack();
        if (block.getBlockType() != expectedBlockType) {
            throw new IOException("Unexpected block type: " + (Object)((Object)block.getBlockType()) + "; expecting " + (Object)((Object)expectedBlockType));
        }
        this.offset += block.getOnDiskSizeWithHeader();
        return block;
    }
}

