/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.cloudwatch;

import com.codahale.metrics.MetricRegistry;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.aws.cloudwatch.CloudWatchReporter;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchMetricsReporter
extends MetricsReporter {
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchMetricsReporter.class);
    private final MetricRegistry registry;
    private final HoodieMetricsConfig metricsConfig;
    private final CloudWatchReporter reporter;

    public CloudWatchMetricsReporter(HoodieWriteConfig writeConfig, MetricRegistry registry) {
        this(writeConfig.getMetricsConfig(), registry);
    }

    CloudWatchMetricsReporter(HoodieWriteConfig writeConfig, MetricRegistry registry, CloudWatchReporter reporter) {
        this(writeConfig.getMetricsConfig(), registry, reporter);
    }

    public CloudWatchMetricsReporter(HoodieMetricsConfig metricsConfig, MetricRegistry registry) {
        this.metricsConfig = metricsConfig;
        this.registry = registry;
        this.reporter = this.createCloudWatchReporter();
    }

    CloudWatchMetricsReporter(HoodieMetricsConfig metricsConfig, MetricRegistry registry, CloudWatchReporter reporter) {
        this.metricsConfig = metricsConfig;
        this.registry = registry;
        this.reporter = reporter;
    }

    private CloudWatchReporter createCloudWatchReporter() {
        return CloudWatchReporter.forRegistry((MetricRegistry)this.registry).prefixedWith(this.metricsConfig.getCloudWatchMetricPrefix()).namespace(this.metricsConfig.getCloudWatchMetricNamespace()).maxDatumsPerRequest(this.metricsConfig.getCloudWatchMaxDatumsPerRequest()).build((Properties)this.metricsConfig.getProps());
    }

    @Override
    public void start() {
        LOG.info("Starting CloudWatch Metrics Reporter.");
        this.reporter.start((long)this.metricsConfig.getCloudWatchReportPeriodSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public void report() {
        this.reporter.report();
    }

    @Override
    public void stop() {
        LOG.info("Stopping CloudWatch Metrics Reporter.");
        this.reporter.stop();
    }
}

