/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.schema;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hudi.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hudi.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.schema.SchemaProvider;

public class SchemaRegistryProvider
extends SchemaProvider {
    private final TypedProperties config;

    public String fetchSchemaFromRegistry(String registryUrl) throws IOException {
        HttpURLConnection connection;
        Matcher matcher = Pattern.compile("://(.*?)@").matcher(registryUrl);
        if (matcher.find()) {
            String creds = matcher.group(1);
            String urlWithoutCreds = registryUrl.replace(creds + "@", "");
            URL registry = new URL(urlWithoutCreds);
            connection = (HttpURLConnection)registry.openConnection();
            this.setAuthorizationHeader(matcher.group(1), connection);
        } else {
            URL registry = new URL(registryUrl);
            connection = (HttpURLConnection)registry.openConnection();
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(this.getStream(connection));
        return node.get("schema").asText();
    }

    protected void setAuthorizationHeader(String creds, HttpURLConnection connection) {
        String encodedAuth = Base64.getEncoder().encodeToString(StringUtils.getUTF8Bytes(creds));
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
    }

    protected InputStream getStream(HttpURLConnection connection) throws IOException {
        return connection.getInputStream();
    }

    public SchemaRegistryProvider(TypedProperties props) {
        this.config = props;
        ConfigUtils.checkRequiredConfigProperties(props, Collections.singletonList(Config.SRC_SCHEMA_REGISTRY_URL));
    }

    private Schema getSchema(String registryUrl) throws IOException {
        return new Schema.Parser().parse(this.fetchSchemaFromRegistry(registryUrl));
    }

    @Override
    public Schema getSourceSchema() {
        String registryUrl = ConfigUtils.getStringWithAltKeys(this.config, (ConfigProperty<String>)Config.SRC_SCHEMA_REGISTRY_URL);
        try {
            return this.getSchema(registryUrl);
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error reading source schema from registry :" + registryUrl, ioe);
        }
    }

    @Override
    public Schema getTargetSchema() {
        String registryUrl = ConfigUtils.getStringWithAltKeys(this.config, (ConfigProperty<String>)Config.SRC_SCHEMA_REGISTRY_URL);
        String targetRegistryUrl = ConfigUtils.getStringWithAltKeys((Properties)this.config, Config.TARGET_SCHEMA_REGISTRY_URL, registryUrl);
        try {
            return this.getSchema(targetRegistryUrl);
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error reading target schema from registry :" + registryUrl, ioe);
        }
    }

    public static class Config {
        private static final ConfigProperty<String> SRC_SCHEMA_REGISTRY_URL = ConfigProperty.key("hoodie.streamer.schemaprovider.registry.url").noDefaultValue().withAlternatives("hoodie.deltastreamer.schemaprovider.registry.url").withDocumentation("The schema of the source you are reading from e.g. https://foo:bar@schemaregistry.org");
        private static final ConfigProperty<String> TARGET_SCHEMA_REGISTRY_URL = ConfigProperty.key("hoodie.streamer.schemaprovider.registry.targetUrl").noDefaultValue().withAlternatives("hoodie.deltastreamer.schemaprovider.registry.targetUrl").withDocumentation("The schema of the target you are writing to e.g. https://foo:bar@schemaregistry.org");
    }
}

