/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow.vector.reader;

import java.io.IOException;
import org.apache.flink.formats.parquet.vector.reader.ColumnReader;
import org.apache.flink.table.data.columnar.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.hudi.table.format.cow.vector.HeapMapColumnVector;
import org.apache.hudi.table.format.cow.vector.reader.ArrayColumnReader;

public class MapColumnReader
implements ColumnReader<WritableColumnVector> {
    private final ArrayColumnReader keyReader;
    private final ColumnReader<WritableColumnVector> valueReader;

    public MapColumnReader(ArrayColumnReader keyReader, ColumnReader<WritableColumnVector> valueReader) {
        this.keyReader = keyReader;
        this.valueReader = valueReader;
    }

    @Override
    public void readToVector(int readNumber, WritableColumnVector vector) throws IOException {
        HeapMapColumnVector mapColumnVector = (HeapMapColumnVector)vector;
        AbstractHeapVector keyArrayColumnVector = (AbstractHeapVector)mapColumnVector.getKeys();
        this.keyReader.readToVector(readNumber, mapColumnVector.getKeys());
        this.valueReader.readToVector(readNumber, mapColumnVector.getValues());
        for (int i = 0; i < keyArrayColumnVector.getLen(); ++i) {
            if (!keyArrayColumnVector.isNullAt(i)) continue;
            mapColumnVector.setNullAt(i);
        }
    }
}

