/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hudi.common.data.HoodieBaseListData;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.FunctionWrapper;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.MappingIterator;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieListPairData<K, V>
extends HoodieBaseListData<Pair<K, V>>
implements HoodiePairData<K, V> {
    private HoodieListPairData(List<Pair<K, V>> data, boolean lazy) {
        super(data, lazy);
    }

    HoodieListPairData(Stream<Pair<K, V>> dataStream, boolean lazy) {
        super(dataStream, lazy);
    }

    @Override
    public List<Pair<K, V>> get() {
        return this.collectAsList();
    }

    @Override
    public void persist(String cacheConfig) {
    }

    @Override
    public void unpersist() {
    }

    @Override
    public HoodieData<K> keys() {
        return new HoodieListData<Object>(this.asStream().map(Pair::getKey), this.lazy);
    }

    @Override
    public HoodieData<V> values() {
        return new HoodieListData<Object>(this.asStream().map(Pair::getValue), this.lazy);
    }

    @Override
    public Map<K, Long> countByKey() {
        return this.asStream().collect(Collectors.groupingBy(Pair::getKey, Collectors.counting()));
    }

    @Override
    public HoodiePairData<K, Iterable<V>> groupByKey() {
        Collector mappingCollector = Collectors.mapping(Pair::getValue, Collectors.toList());
        Collector groupingCollector = Collectors.groupingBy(Pair::getKey, mappingCollector);
        Map groupedByKey = this.asStream().collect(groupingCollector);
        return new HoodieListPairData<K, V>(groupedByKey.entrySet().stream().map((? super T e) -> Pair.of(e.getKey(), e.getValue())), this.lazy);
    }

    @Override
    public HoodiePairData<K, V> reduceByKey(SerializableBiFunction<V, V, V> combiner, int parallelism) {
        Map reducedMap = this.asStream().collect(Collectors.groupingBy(Pair::getKey, HashMap::new, Collectors.mapping(Pair::getValue, Collectors.reducing(combiner::apply))));
        return new HoodieListPairData<K, V>(reducedMap.entrySet().stream().map((? super T e) -> Pair.of(e.getKey(), ((Optional)e.getValue()).orElse(null))), this.lazy);
    }

    @Override
    public <O> HoodieData<O> map(SerializableFunction<Pair<K, V>, O> func) {
        Function<Pair<K, V>, O> uncheckedMapper = FunctionWrapper.throwingMapWrapper(func);
        return new HoodieListData<O>(this.asStream().map(uncheckedMapper), this.lazy);
    }

    @Override
    public <W> HoodiePairData<K, W> mapValues(SerializableFunction<V, W> func) {
        Function uncheckedMapper = FunctionWrapper.throwingMapWrapper(func);
        return new HoodieListPairData<K, V>(this.asStream().map((? super T p) -> Pair.of(p.getKey(), uncheckedMapper.apply(p.getValue()))), this.lazy);
    }

    @Override
    public <W> HoodiePairData<K, W> flatMapValues(SerializableFunction<V, Iterator<W>> func) {
        Function uncheckedMapper = FunctionWrapper.throwingMapWrapper(func);
        return new HoodieListPairData<K, V>(this.asStream().flatMap(p -> {
            Iterator mappedValuesIterator = (Iterator)uncheckedMapper.apply(p.getValue());
            MappingIterator<Object, Pair> mappedPairsIterator = new MappingIterator<Object, Pair>(mappedValuesIterator, w -> Pair.of(p.getKey(), w));
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(mappedPairsIterator, 16), true);
        }), this.lazy);
    }

    @Override
    public <L, W> HoodiePairData<L, W> mapToPair(SerializablePairFunction<Pair<K, V>, L, W> mapToPairFunc) {
        return new HoodieListPairData<K, V>(this.asStream().map((? super T p) -> FunctionWrapper.throwingMapToPairWrapper(mapToPairFunc).apply(p)), this.lazy);
    }

    @Override
    public <W> HoodiePairData<K, Pair<V, Option<W>>> leftOuterJoin(HoodiePairData<K, W> other) {
        ValidationUtils.checkArgument(other instanceof HoodieListPairData);
        HashMap rightStreamMap = ((HoodieListPairData)other).asStream().collect(Collectors.groupingBy(Pair::getKey, HashMap::new, Collectors.mapping(Pair::getValue, Collectors.toList())));
        Stream<Pair<K, V>> leftOuterJoined = this.asStream().flatMap(pair -> {
            Object key = pair.getKey();
            Object leftValue = pair.getValue();
            List rightValues = (List)rightStreamMap.get(key);
            if (rightValues == null) {
                return Stream.of(Pair.of(key, Pair.of(leftValue, Option.empty())));
            }
            return rightValues.stream().map((? super T rightValue) -> Pair.of(key, Pair.of(leftValue, Option.of(rightValue))));
        });
        return new HoodieListPairData<K, V>(leftOuterJoined, this.lazy);
    }

    @Override
    public HoodiePairData<K, V> union(HoodiePairData<K, V> other) {
        ValidationUtils.checkArgument(other instanceof HoodieListPairData);
        Stream<Pair<K, V>> unionStream = Stream.concat(this.asStream(), ((HoodieListPairData)other).asStream());
        return new HoodieListPairData<K, V>(unionStream, this.lazy);
    }

    @Override
    public long count() {
        return super.count();
    }

    @Override
    public List<Pair<K, V>> collectAsList() {
        return super.collectAsList();
    }

    @Override
    public int deduceNumPartitions() {
        return 1;
    }

    public static <K, V> HoodieListPairData<K, V> lazy(List<Pair<K, V>> data) {
        return new HoodieListPairData<K, V>(data, true);
    }

    public static <K, V> HoodieListPairData<K, V> eager(List<Pair<K, V>> data) {
        return new HoodieListPairData<K, V>(data, false);
    }

    public static <K, V> HoodieListPairData<K, V> lazy(Map<K, List<V>> data) {
        return new HoodieListPairData<K, V>(HoodieListPairData.explode(data), true);
    }

    public static <K, V> HoodieListPairData<K, V> eager(Map<K, List<V>> data) {
        return new HoodieListPairData<K, V>(HoodieListPairData.explode(data), false);
    }

    private static <K, V> Stream<Pair<K, V>> explode(Map<K, List<V>> data) {
        return data.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map((? super T v) -> Pair.of(e.getKey(), v)));
    }
}

