/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hadoop.HoodieHiveRecord;
import org.apache.hudi.hadoop.HoodieHiveRecordMerger;
import org.apache.hudi.org.apache.avro.Schema;

public class DefaultHiveRecordMerger
extends HoodieHiveRecordMerger {
    @Override
    public Option<Pair<HoodieRecord, Schema>> merge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, TypedProperties props) throws IOException {
        HoodieHiveRecord newHiveRecord;
        ValidationUtils.checkArgument(older.getRecordType() == HoodieRecord.HoodieRecordType.HIVE);
        ValidationUtils.checkArgument(newer.getRecordType() == HoodieRecord.HoodieRecordType.HIVE);
        if (newer instanceof HoodieHiveRecord ? (newHiveRecord = (HoodieHiveRecord)newer).isDeleted() : newer.getData() == null) {
            return Option.empty();
        }
        if (older instanceof HoodieHiveRecord) {
            HoodieHiveRecord oldHiveRecord = (HoodieHiveRecord)older;
            if (oldHiveRecord.isDeleted()) {
                return Option.of(Pair.of(newer, newSchema));
            }
        } else if (older.getData() == null) {
            return Option.empty();
        }
        if (older.getOrderingValue(oldSchema, props).compareTo(newer.getOrderingValue(newSchema, props)) > 0) {
            return Option.of(Pair.of(older, oldSchema));
        }
        return Option.of(Pair.of(newer, newSchema));
    }

    @Override
    public String getMergingStrategy() {
        return "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
    }
}

