/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.HoodieCompactor;

public class HoodieFlinkMergeOnReadTableCompactor<T>
extends HoodieCompactor<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    @Override
    public void preCompact(HoodieTable table, HoodieTimeline pendingCompactionTimeline, WriteOperationType operationType, String instantTime) {
        HoodieInstant inflightInstant;
        InstantGenerator instantGenerator = table.getInstantGenerator();
        HoodieInstant hoodieInstant = inflightInstant = WriteOperationType.COMPACT.equals((Object)operationType) ? instantGenerator.getCompactionInflightInstant(instantTime) : instantGenerator.getLogCompactionInflightInstant(instantTime);
        if (pendingCompactionTimeline.containsInstant(inflightInstant)) {
            table.rollbackInflightCompaction(inflightInstant);
            table.getMetaClient().reloadActiveTimeline();
        }
    }

    @Override
    public void maybePersist(HoodieData<WriteStatus> writeStatus, HoodieEngineContext context, HoodieWriteConfig config, String instantTime) {
    }
}

