/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.InternalSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.configuration.OptionsResolver;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.InternalSchemaMerger;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.table.format.CastMap;
import org.apache.hudi.util.AvroSchemaConverter;

public class InternalSchemaManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final InternalSchemaManager DISABLED = new InternalSchemaManager(null, InternalSchema.getEmptyInternalSchema(), null, null, TimelineLayout.fromVersion(TimelineLayoutVersion.CURR_LAYOUT_VERSION));
    private final Configuration conf;
    private final InternalSchema querySchema;
    private final String validCommits;
    private final String tablePath;
    private final TimelineLayout layout;
    private transient org.apache.hadoop.conf.Configuration hadoopConf;

    public static InternalSchemaManager get(Configuration conf, HoodieTableMetaClient metaClient) {
        if (!OptionsResolver.isSchemaEvolutionEnabled(conf)) {
            return DISABLED;
        }
        Option<InternalSchema> internalSchema = new TableSchemaResolver(metaClient).getTableInternalSchemaFromCommitMetadata();
        if (!internalSchema.isPresent() || internalSchema.get().isEmptySchema()) {
            return DISABLED;
        }
        InstantFileNameGenerator factory = metaClient.getInstantFileNameGenerator();
        String validCommits = metaClient.getCommitsAndCompactionTimeline().filterCompletedInstants().getInstantsAsStream().map(factory::getFileName).collect(Collectors.joining(","));
        return new InternalSchemaManager(conf, internalSchema.get(), validCommits, metaClient.getBasePath().toString(), metaClient.getTimelineLayout());
    }

    public InternalSchemaManager(Configuration conf, InternalSchema querySchema, String validCommits, String tablePath, TimelineLayout layout) {
        this.conf = conf;
        this.querySchema = querySchema;
        this.validCommits = validCommits;
        this.tablePath = tablePath;
        this.layout = layout;
    }

    public InternalSchema getQuerySchema() {
        return this.querySchema;
    }

    InternalSchema getMergeSchema(String fileName) {
        if (this.querySchema.isEmptySchema()) {
            return this.querySchema;
        }
        long commitInstantTime = Long.parseLong(FSUtils.getCommitTime(fileName));
        InternalSchema fileSchema = InternalSchemaCache.getInternalSchemaByVersionId(commitInstantTime, this.tablePath, new HoodieHadoopStorage(this.tablePath, this.getHadoopConf()), this.validCommits, this.layout.getInstantFileNameParser(), this.layout.getCommitMetadataSerDe(), this.layout.getInstantGenerator());
        if (this.querySchema.equals(fileSchema)) {
            return InternalSchema.getEmptyInternalSchema();
        }
        return new InternalSchemaMerger(fileSchema, this.querySchema, true, true).mergeSchema();
    }

    CastMap getCastMap(InternalSchema mergeSchema, String[] queryFieldNames, DataType[] queryFieldTypes, int[] selectedFields) {
        Preconditions.checkArgument((!this.querySchema.isEmptySchema() ? 1 : 0) != 0, (Object)"querySchema cannot be empty");
        Preconditions.checkArgument((!mergeSchema.isEmptySchema() ? 1 : 0) != 0, (Object)"mergeSchema cannot be empty");
        CastMap castMap = new CastMap();
        Map<Integer, Integer> posProxy = this.getPosProxy(mergeSchema, queryFieldNames);
        if (posProxy.isEmpty()) {
            castMap.setFileFieldTypes(queryFieldTypes);
            return castMap;
        }
        List selectedFieldList = IntStream.of(selectedFields).boxed().collect(Collectors.toList());
        List mergeSchemaAsDataTypes = AvroSchemaConverter.convertToDataType(AvroInternalSchemaConverter.convert(mergeSchema, "tableName")).getChildren();
        DataType[] fileFieldTypes = new DataType[queryFieldTypes.length];
        for (int i = 0; i < queryFieldTypes.length; ++i) {
            DataType fileType;
            Integer posOfChangedType = posProxy.get(i);
            if (posOfChangedType == null) {
                fileFieldTypes[i] = queryFieldTypes[i];
                continue;
            }
            fileFieldTypes[i] = fileType = (DataType)mergeSchemaAsDataTypes.get(posOfChangedType);
            int selectedPos = selectedFieldList.indexOf(i);
            if (selectedPos == -1) continue;
            castMap.add(selectedPos, fileType.getLogicalType(), queryFieldTypes[i].getLogicalType());
        }
        castMap.setFileFieldTypes(fileFieldTypes);
        return castMap;
    }

    String[] getMergeFieldNames(InternalSchema mergeSchema, String[] queryFieldNames) {
        Preconditions.checkArgument((!this.querySchema.isEmptySchema() ? 1 : 0) != 0, (Object)"querySchema cannot be empty");
        Preconditions.checkArgument((!mergeSchema.isEmptySchema() ? 1 : 0) != 0, (Object)"mergeSchema cannot be empty");
        Map<String, String> renamedCols = InternalSchemaUtils.collectRenameCols(mergeSchema, this.querySchema);
        if (renamedCols.isEmpty()) {
            return queryFieldNames;
        }
        return (String[])Arrays.stream(queryFieldNames).map(name -> renamedCols.getOrDefault(name, (String)name)).toArray(String[]::new);
    }

    private Map<Integer, Integer> getPosProxy(InternalSchema mergeSchema, String[] queryFieldNames) {
        Map<Integer, Pair<Type, Type>> changedCols = InternalSchemaUtils.collectTypeChangedCols(this.querySchema, mergeSchema);
        HashMap posProxy = new HashMap(changedCols.size());
        List<String> fieldNameList = Arrays.asList(queryFieldNames);
        List<Types.Field> columns = this.querySchema.columns();
        changedCols.forEach((posInSchema, typePair) -> {
            String name = ((Types.Field)columns.get((int)posInSchema)).name();
            int posInType = fieldNameList.indexOf(name);
            posProxy.put(posInType, posInSchema);
        });
        return Collections.unmodifiableMap(posProxy);
    }

    private org.apache.hadoop.conf.Configuration getHadoopConf() {
        if (this.hadoopConf == null) {
            this.hadoopConf = HadoopConfigurations.getHadoopConf(this.conf);
        }
        return this.hadoopConf;
    }
}

