/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.IOException;
import java.util.Locale;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.client.FlinkTaskContextSupplier;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.configuration.HadoopConfigurations;
import org.apache.hudi.configuration.OptionsResolver;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilterMode;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.util.StreamerUtil;
import org.apache.hudi.util.ViewStorageProperties;

public class FlinkWriteClients {
    public static HoodieFlinkWriteClient createWriteClient(Configuration conf) throws IOException {
        HoodieWriteConfig writeConfig = FlinkWriteClients.getHoodieClientConfig(conf, true, false);
        HoodieFlinkWriteClient writeClient = new HoodieFlinkWriteClient(new HoodieFlinkEngineContext(HadoopConfigurations.getHadoopConf(conf)), writeConfig);
        writeClient.setOperationType(WriteOperationType.fromValue(conf.getString(FlinkOptions.OPERATION)));
        FileSystemViewStorageConfig viewStorageConfig = writeConfig.getViewStorageConfig();
        FileSystemViewStorageConfig rebuilt = FileSystemViewStorageConfig.newBuilder().withStorageType(viewStorageConfig.getStorageType()).withRemoteServerHost(viewStorageConfig.getRemoteViewServerHost()).withRemoteServerPort(viewStorageConfig.getRemoteViewServerPort()).withRemoteTimelineClientTimeoutSecs(viewStorageConfig.getRemoteTimelineClientTimeoutSecs()).withRemoteTimelineClientRetry(viewStorageConfig.isRemoteTimelineClientRetryEnabled()).withRemoteTimelineClientMaxRetryNumbers(viewStorageConfig.getRemoteTimelineClientMaxRetryNumbers()).withRemoteTimelineInitialRetryIntervalMs(viewStorageConfig.getRemoteTimelineInitialRetryIntervalMs()).withRemoteTimelineClientMaxRetryIntervalMs(viewStorageConfig.getRemoteTimelineClientMaxRetryIntervalMs()).withRemoteTimelineClientRetryExceptions(viewStorageConfig.getRemoteTimelineClientRetryExceptions()).build();
        ViewStorageProperties.createProperties(conf.getString(FlinkOptions.PATH), rebuilt, conf);
        return writeClient;
    }

    public static HoodieFlinkWriteClient createWriteClientV2(Configuration conf) {
        HoodieWriteConfig writeConfig = FlinkWriteClients.getHoodieClientConfig(conf, true, false);
        HoodieFlinkWriteClient writeClient = new HoodieFlinkWriteClient(new HoodieFlinkEngineContext(HadoopConfigurations.getHadoopConf(conf)), writeConfig);
        writeClient.setOperationType(WriteOperationType.fromValue(conf.getString(FlinkOptions.OPERATION)));
        FileSystemViewStorageConfig viewStorageConfig = writeConfig.getViewStorageConfig();
        conf.setString(FileSystemViewStorageConfig.VIEW_TYPE.key(), viewStorageConfig.getStorageType().name());
        conf.setString(FileSystemViewStorageConfig.REMOTE_HOST_NAME.key(), viewStorageConfig.getRemoteViewServerHost());
        conf.setInteger(FileSystemViewStorageConfig.REMOTE_PORT_NUM.key(), viewStorageConfig.getRemoteViewServerPort().intValue());
        return writeClient;
    }

    public static HoodieFlinkWriteClient createWriteClient(Configuration conf, RuntimeContext runtimeContext) {
        return FlinkWriteClients.createWriteClient(conf, runtimeContext, true);
    }

    public static HoodieFlinkWriteClient createWriteClient(Configuration conf, RuntimeContext runtimeContext, boolean loadFsViewStorageConfig) {
        HoodieFlinkEngineContext context = new HoodieFlinkEngineContext(HadoopFSUtils.getStorageConf(HadoopConfigurations.getHadoopConf(conf)), new FlinkTaskContextSupplier(runtimeContext));
        HoodieWriteConfig writeConfig = FlinkWriteClients.getHoodieClientConfig(conf, loadFsViewStorageConfig);
        return new HoodieFlinkWriteClient(context, writeConfig);
    }

    public static HoodieWriteConfig getHoodieClientConfig(Configuration conf) {
        return FlinkWriteClients.getHoodieClientConfig(conf, false, false);
    }

    public static HoodieWriteConfig getHoodieClientConfig(Configuration conf, boolean loadFsViewStorageConfig) {
        return FlinkWriteClients.getHoodieClientConfig(conf, false, loadFsViewStorageConfig);
    }

    public static HoodieWriteConfig getHoodieClientConfig(Configuration conf, boolean enableEmbeddedTimelineService, boolean loadFsViewStorageConfig) {
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withEngineType(EngineType.FLINK).withPath(conf.getString(FlinkOptions.PATH)).combineInput(conf.getBoolean(FlinkOptions.PRE_COMBINE), true).withWriteTableVersion(conf.getInteger(FlinkOptions.WRITE_TABLE_VERSION)).withMergeAllowDuplicateOnInserts(OptionsResolver.insertClustering(conf)).withClusteringConfig(HoodieClusteringConfig.newBuilder().withClusteringPlanStrategyClass(conf.getString(FlinkOptions.CLUSTERING_PLAN_STRATEGY_CLASS, OptionsResolver.getDefaultPlanStrategyClassName(conf))).withClusteringPlanPartitionFilterMode(ClusteringPlanPartitionFilterMode.valueOf(conf.getString(FlinkOptions.CLUSTERING_PLAN_PARTITION_FILTER_MODE_NAME))).withClusteringTargetPartitions(conf.getInteger(FlinkOptions.CLUSTERING_TARGET_PARTITIONS)).withClusteringMaxNumGroups(conf.getInteger(FlinkOptions.CLUSTERING_MAX_NUM_GROUPS)).withClusteringTargetFileMaxBytes(conf.getLong(FlinkOptions.CLUSTERING_PLAN_STRATEGY_TARGET_FILE_MAX_BYTES)).withClusteringPlanSmallFileLimit(conf.getLong(FlinkOptions.CLUSTERING_PLAN_STRATEGY_SMALL_FILE_LIMIT) * 1024L * 1024L).withClusteringSkipPartitionsFromLatest(conf.getInteger(FlinkOptions.CLUSTERING_PLAN_STRATEGY_SKIP_PARTITIONS_FROM_LATEST)).withClusteringPartitionFilterBeginPartition((String)conf.get(FlinkOptions.CLUSTERING_PLAN_STRATEGY_CLUSTER_BEGIN_PARTITION)).withClusteringPartitionFilterEndPartition((String)conf.get(FlinkOptions.CLUSTERING_PLAN_STRATEGY_CLUSTER_END_PARTITION)).withClusteringPartitionRegexPattern((String)conf.get(FlinkOptions.CLUSTERING_PLAN_STRATEGY_PARTITION_REGEX_PATTERN)).withClusteringPartitionSelected((String)conf.get(FlinkOptions.CLUSTERING_PLAN_STRATEGY_PARTITION_SELECTED)).withAsyncClusteringMaxCommits(conf.getInteger(FlinkOptions.CLUSTERING_DELTA_COMMITS)).withScheduleInlineClustering(conf.getBoolean(FlinkOptions.CLUSTERING_SCHEDULE_ENABLED)).withAsyncClustering(conf.getBoolean(FlinkOptions.CLUSTERING_ASYNC_ENABLED)).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withAsyncClean(conf.getBoolean(FlinkOptions.CLEAN_ASYNC_ENABLED)).retainCommits(conf.getInteger(FlinkOptions.CLEAN_RETAIN_COMMITS)).cleanerNumHoursRetained(conf.getInteger(FlinkOptions.CLEAN_RETAIN_HOURS)).retainFileVersions(conf.getInteger(FlinkOptions.CLEAN_RETAIN_FILE_VERSIONS)).withCleanerParallelism(20).withCleanerPolicy(HoodieCleaningPolicy.valueOf(conf.getString(FlinkOptions.CLEAN_POLICY))).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(conf.getInteger(FlinkOptions.ARCHIVE_MIN_COMMITS), conf.getInteger(FlinkOptions.ARCHIVE_MAX_COMMITS)).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withTargetIOPerCompactionInMB(conf.getLong(FlinkOptions.COMPACTION_TARGET_IO)).withInlineCompactionTriggerStrategy(CompactionTriggerStrategy.valueOf(conf.getString(FlinkOptions.COMPACTION_TRIGGER_STRATEGY).toUpperCase(Locale.ROOT))).withMaxNumDeltaCommitsBeforeCompaction(conf.getInteger(FlinkOptions.COMPACTION_DELTA_COMMITS)).withMaxDeltaSecondsBeforeCompaction(conf.getInteger(FlinkOptions.COMPACTION_DELTA_SECONDS)).build()).withMemoryConfig(HoodieMemoryConfig.newBuilder().withMaxMemoryMaxSize((long)(conf.getInteger(FlinkOptions.WRITE_MERGE_MAX_MEMORY) * 1024) * 1024L, (long)(conf.getInteger(FlinkOptions.COMPACTION_MAX_MEMORY) * 1024) * 1024L).build()).forTable(conf.getString(FlinkOptions.TABLE_NAME)).withStorageConfig(HoodieStorageConfig.newBuilder().logFileDataBlockMaxSize(conf.getInteger(FlinkOptions.WRITE_LOG_BLOCK_SIZE) * 1024 * 1024).logFileMaxSize(conf.getLong(FlinkOptions.WRITE_LOG_MAX_SIZE) * 1024L * 1024L).parquetBlockSize(conf.getInteger(FlinkOptions.WRITE_PARQUET_BLOCK_SIZE) * 1024 * 1024).parquetPageSize(conf.getInteger(FlinkOptions.WRITE_PARQUET_PAGE_SIZE) * 1024 * 1024).parquetMaxFileSize((long)(conf.getInteger(FlinkOptions.WRITE_PARQUET_MAX_FILE_SIZE) * 1024) * 1024L).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(conf.getBoolean(FlinkOptions.METADATA_ENABLED)).withMaxNumDeltaCommitsBeforeCompaction(conf.getInteger(FlinkOptions.METADATA_COMPACTION_DELTA_COMMITS)).build()).withIndexConfig(StreamerUtil.getIndexConfig(conf)).withPayloadConfig(StreamerUtil.getPayloadConfig(conf)).withEmbeddedTimelineServerEnabled(enableEmbeddedTimelineService).withEmbeddedTimelineServerReuseEnabled(true).withAutoCommit(false).withAllowOperationMetadataField(conf.getBoolean(FlinkOptions.CHANGELOG_ENABLED)).withProps(StreamerUtil.flinkConf2TypedProperties(conf)).withSchema(StreamerUtil.getSourceSchema(conf).toString());
        Option<HoodieLockConfig> lockConfig = StreamerUtil.getLockConfig(conf);
        if (lockConfig.isPresent()) {
            builder.withLockConfig(lockConfig.get());
        }
        HoodieWriteConfig writeConfig = builder.build();
        if (loadFsViewStorageConfig && !conf.containsKey(FileSystemViewStorageConfig.REMOTE_HOST_NAME.key())) {
            FileSystemViewStorageConfig viewStorageConfig = ViewStorageProperties.loadFromProperties(conf.getString(FlinkOptions.PATH), conf);
            writeConfig.setViewStorageConfig(viewStorageConfig);
        }
        return writeConfig;
    }
}

