/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow.vector;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.hudi.table.format.cow.vector.HeapArrayGroupColumnVector;
import org.apache.hudi.table.format.cow.vector.HeapArrayVector;

public class ColumnarGroupMapData
implements MapData {
    WritableColumnVector keyVector;
    WritableColumnVector valueVector;
    int rowId;

    public ColumnarGroupMapData(WritableColumnVector keyVector, WritableColumnVector valueVector, int rowId) {
        this.keyVector = keyVector;
        this.valueVector = valueVector;
        this.rowId = rowId;
    }

    public int size() {
        if (this.keyVector == null) {
            return 0;
        }
        if (this.keyVector instanceof HeapArrayVector) {
            return ((HeapArrayVector)this.keyVector).getArray(this.rowId).size();
        }
        throw new UnsupportedOperationException(this.keyVector.getClass().getName() + " is not supported. Supported vector types: HeapArrayVector");
    }

    public ArrayData keyArray() {
        return ((HeapArrayVector)this.keyVector).getArray(this.rowId);
    }

    public ArrayData valueArray() {
        if (this.valueVector instanceof HeapArrayVector) {
            return ((HeapArrayVector)this.valueVector).getArray(this.rowId);
        }
        if (this.valueVector instanceof HeapArrayGroupColumnVector) {
            return ((HeapArrayGroupColumnVector)this.valueVector).getArray(this.rowId);
        }
        throw new UnsupportedOperationException(this.valueVector.getClass().getName() + " is not supported. Supported vector types: HeapArrayVector, HeapArrayGroupColumnVector");
    }
}

