/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.parquet.vector.reader.BooleanColumnReader;
import org.apache.flink.formats.parquet.vector.reader.ByteColumnReader;
import org.apache.flink.formats.parquet.vector.reader.BytesColumnReader;
import org.apache.flink.formats.parquet.vector.reader.ColumnReader;
import org.apache.flink.formats.parquet.vector.reader.DoubleColumnReader;
import org.apache.flink.formats.parquet.vector.reader.FloatColumnReader;
import org.apache.flink.formats.parquet.vector.reader.IntColumnReader;
import org.apache.flink.formats.parquet.vector.reader.LongColumnReader;
import org.apache.flink.formats.parquet.vector.reader.ShortColumnReader;
import org.apache.flink.formats.parquet.vector.reader.TimestampColumnReader;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.columnar.vector.ColumnVector;
import org.apache.flink.table.data.columnar.vector.VectorizedColumnBatch;
import org.apache.flink.table.data.columnar.vector.heap.HeapBooleanVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapByteVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapBytesVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapDoubleVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapFloatVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapIntVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapLongVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapShortVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapTimestampVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.table.format.cow.vector.HeapArrayGroupColumnVector;
import org.apache.hudi.table.format.cow.vector.HeapArrayVector;
import org.apache.hudi.table.format.cow.vector.HeapDecimalVector;
import org.apache.hudi.table.format.cow.vector.HeapMapColumnVector;
import org.apache.hudi.table.format.cow.vector.HeapRowColumnVector;
import org.apache.hudi.table.format.cow.vector.reader.ArrayColumnReader;
import org.apache.hudi.table.format.cow.vector.reader.ArrayGroupReader;
import org.apache.hudi.table.format.cow.vector.reader.EmptyColumnReader;
import org.apache.hudi.table.format.cow.vector.reader.FixedLenBytesColumnReader;
import org.apache.hudi.table.format.cow.vector.reader.Int64TimestampColumnReader;
import org.apache.hudi.table.format.cow.vector.reader.MapColumnReader;
import org.apache.hudi.table.format.cow.vector.reader.ParquetColumnarRowSplitReader;
import org.apache.hudi.table.format.cow.vector.reader.RowColumnReader;
import org.apache.parquet.ParquetRuntimeException;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.InvalidSchemaException;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetSplitReaderUtil {
    public static ParquetColumnarRowSplitReader genPartColumnarRowReader(boolean utcTimestamp, boolean caseSensitive, Configuration conf, String[] fullFieldNames, DataType[] fullFieldTypes, Map<String, Object> partitionSpec, int[] selectedFields, int batchSize, Path path, long splitStart, long splitLength, FilterPredicate filterPredicate, UnboundRecordFilter recordFilter) throws IOException {
        ValidationUtils.checkState((boolean)Arrays.stream(selectedFields).noneMatch(x -> x == -1), (String)"One or more specified columns does not exist in the hudi table.");
        List<String> selNonPartNames = Arrays.stream(selectedFields).mapToObj(i -> fullFieldNames[i]).filter(n -> !partitionSpec.containsKey(n)).collect(Collectors.toList());
        int[] selParquetFields = Arrays.stream(selectedFields).filter(i -> !partitionSpec.containsKey(fullFieldNames[i])).toArray();
        ParquetColumnarRowSplitReader.ColumnBatchGenerator gen = readVectors -> {
            ColumnVector[] vectors = new ColumnVector[selectedFields.length];
            for (int i = 0; i < vectors.length; ++i) {
                String name = fullFieldNames[selectedFields[i]];
                LogicalType type = fullFieldTypes[selectedFields[i]].getLogicalType();
                vectors[i] = ParquetSplitReaderUtil.createVector(readVectors, selNonPartNames, name, type, partitionSpec, batchSize);
            }
            return new VectorizedColumnBatch(vectors);
        };
        return new ParquetColumnarRowSplitReader(utcTimestamp, caseSensitive, conf, (LogicalType[])Arrays.stream(selParquetFields).mapToObj(i -> fullFieldTypes[i].getLogicalType()).toArray(LogicalType[]::new), selNonPartNames.toArray(new String[0]), gen, batchSize, new org.apache.hadoop.fs.Path(path.toUri()), splitStart, splitLength, filterPredicate, recordFilter);
    }

    private static ColumnVector createVector(ColumnVector[] readVectors, List<String> selNonPartNames, String name, LogicalType type, Map<String, Object> partitionSpec, int batchSize) {
        if (partitionSpec.containsKey(name)) {
            return ParquetSplitReaderUtil.createVectorFromConstant(type, partitionSpec.get(name), batchSize);
        }
        ColumnVector readVector = readVectors[selNonPartNames.indexOf(name)];
        if (readVector == null) {
            readVector = ParquetSplitReaderUtil.createVectorFromConstant(type, null, batchSize);
        }
        return readVector;
    }

    private static ColumnVector createVectorFromConstant(LogicalType type, Object value, int batchSize) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                HeapBytesVector bsv = new HeapBytesVector(batchSize);
                if (value == null) {
                    bsv.fillWithNulls();
                } else {
                    bsv.fill(value instanceof byte[] ? (byte[])value : StringUtils.getUTF8Bytes((String)value.toString()));
                }
                return bsv;
            }
            case BOOLEAN: {
                HeapBooleanVector bv = new HeapBooleanVector(batchSize);
                if (value == null) {
                    bv.fillWithNulls();
                } else {
                    bv.fill(((Boolean)value).booleanValue());
                }
                return bv;
            }
            case TINYINT: {
                HeapByteVector byteVector = new HeapByteVector(batchSize);
                if (value == null) {
                    byteVector.fillWithNulls();
                } else {
                    byteVector.fill(((Number)value).byteValue());
                }
                return byteVector;
            }
            case SMALLINT: {
                HeapShortVector sv = new HeapShortVector(batchSize);
                if (value == null) {
                    sv.fillWithNulls();
                } else {
                    sv.fill(((Number)value).shortValue());
                }
                return sv;
            }
            case INTEGER: {
                HeapIntVector iv = new HeapIntVector(batchSize);
                if (value == null) {
                    iv.fillWithNulls();
                } else {
                    iv.fill(((Number)value).intValue());
                }
                return iv;
            }
            case BIGINT: {
                HeapLongVector lv = new HeapLongVector(batchSize);
                if (value == null) {
                    lv.fillWithNulls();
                } else {
                    lv.fill(((Number)value).longValue());
                }
                return lv;
            }
            case DECIMAL: {
                HeapDecimalVector decv = new HeapDecimalVector(batchSize);
                if (value == null) {
                    decv.fillWithNulls();
                } else {
                    DecimalType decimalType = (DecimalType)type;
                    int precision = decimalType.getPrecision();
                    int scale = decimalType.getScale();
                    DecimalData decimal = (DecimalData)Preconditions.checkNotNull((Object)DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)value), (int)precision, (int)scale));
                    decv.fill(decimal.toUnscaledBytes());
                }
                return decv;
            }
            case FLOAT: {
                HeapFloatVector fv = new HeapFloatVector(batchSize);
                if (value == null) {
                    fv.fillWithNulls();
                } else {
                    fv.fill(((Number)value).floatValue());
                }
                return fv;
            }
            case DOUBLE: {
                HeapDoubleVector dv = new HeapDoubleVector(batchSize);
                if (value == null) {
                    dv.fillWithNulls();
                } else {
                    dv.fill(((Number)value).doubleValue());
                }
                return dv;
            }
            case DATE: {
                if (value instanceof LocalDate) {
                    value = Date.valueOf((LocalDate)value);
                }
                return ParquetSplitReaderUtil.createVectorFromConstant((LogicalType)new IntType(), value == null ? null : Integer.valueOf(DateTimeUtils.toInternal((Date)((Date)value))), batchSize);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                HeapTimestampVector tv = new HeapTimestampVector(batchSize);
                if (value == null) {
                    tv.fillWithNulls();
                } else {
                    tv.fill(TimestampData.fromLocalDateTime((LocalDateTime)((LocalDateTime)value)));
                }
                return tv;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                if (arrayType.getElementType().isAnyOf(new LogicalTypeFamily[]{LogicalTypeFamily.CONSTRUCTED})) {
                    HeapArrayGroupColumnVector arrayGroup = new HeapArrayGroupColumnVector(batchSize);
                    if (value == null) {
                        arrayGroup.fillWithNulls();
                        return arrayGroup;
                    }
                    throw new UnsupportedOperationException("Unsupported create array with default value.");
                }
                HeapArrayVector arrayVector = new HeapArrayVector(batchSize);
                if (value == null) {
                    arrayVector.fillWithNulls();
                    return arrayVector;
                }
                throw new UnsupportedOperationException("Unsupported create array with default value.");
            }
            case MAP: {
                HeapMapColumnVector mapVector = new HeapMapColumnVector(batchSize, null, null);
                if (value == null) {
                    mapVector.fillWithNulls();
                    return mapVector;
                }
                throw new UnsupportedOperationException("Unsupported create map with default value.");
            }
            case ROW: {
                HeapRowColumnVector rowVector = new HeapRowColumnVector(batchSize, new WritableColumnVector[0]);
                if (value == null) {
                    rowVector.fillWithNulls();
                    return rowVector;
                }
                throw new UnsupportedOperationException("Unsupported create row with default value.");
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static List<ColumnDescriptor> filterDescriptors(int depth, Type type, List<ColumnDescriptor> columns) throws ParquetRuntimeException {
        ArrayList<ColumnDescriptor> filtered = new ArrayList<ColumnDescriptor>();
        for (ColumnDescriptor descriptor : columns) {
            if (depth >= descriptor.getPath().length) {
                throw new InvalidSchemaException("Expect depth " + depth + " for schema: " + descriptor);
            }
            if (!type.getName().equals(descriptor.getPath()[depth])) continue;
            filtered.add(descriptor);
        }
        ValidationUtils.checkState((filtered.size() > 0 ? 1 : 0) != 0, (String)"Corrupted Parquet schema");
        return filtered;
    }

    public static ColumnReader createColumnReader(boolean utcTimestamp, LogicalType fieldType, Type physicalType, List<ColumnDescriptor> descriptors, PageReadStore pages) throws IOException {
        return ParquetSplitReaderUtil.createColumnReader(utcTimestamp, fieldType, physicalType, descriptors, pages, 0);
    }

    private static ColumnReader createColumnReader(boolean utcTimestamp, LogicalType fieldType, Type physicalType, List<ColumnDescriptor> columns, PageReadStore pages, int depth) throws IOException {
        List<ColumnDescriptor> descriptors = ParquetSplitReaderUtil.filterDescriptors(depth, physicalType, columns);
        ColumnDescriptor descriptor = descriptors.get(0);
        PageReader pageReader = pages.getPageReader(descriptor);
        switch (fieldType.getTypeRoot()) {
            case BOOLEAN: {
                return new BooleanColumnReader(descriptor, pageReader);
            }
            case TINYINT: {
                return new ByteColumnReader(descriptor, pageReader);
            }
            case DOUBLE: {
                return new DoubleColumnReader(descriptor, pageReader);
            }
            case FLOAT: {
                return new FloatColumnReader(descriptor, pageReader);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                return new IntColumnReader(descriptor, pageReader);
            }
            case BIGINT: {
                return new LongColumnReader(descriptor, pageReader);
            }
            case SMALLINT: {
                return new ShortColumnReader(descriptor, pageReader);
            }
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return new BytesColumnReader(descriptor, pageReader);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                switch (descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                    case INT64: {
                        int precision = fieldType instanceof TimestampType ? ((TimestampType)fieldType).getPrecision() : ((LocalZonedTimestampType)fieldType).getPrecision();
                        return new Int64TimestampColumnReader(utcTimestamp, descriptor, pageReader, precision);
                    }
                    case INT96: {
                        return new TimestampColumnReader(utcTimestamp, descriptor, pageReader);
                    }
                }
                throw new AssertionError();
            }
            case DECIMAL: {
                switch (descriptor.getPrimitiveType().getPrimitiveTypeName()) {
                    case INT32: {
                        return new IntColumnReader(descriptor, pageReader);
                    }
                    case INT64: {
                        return new LongColumnReader(descriptor, pageReader);
                    }
                    case BINARY: {
                        return new BytesColumnReader(descriptor, pageReader);
                    }
                    case FIXED_LEN_BYTE_ARRAY: {
                        return new FixedLenBytesColumnReader(descriptor, pageReader);
                    }
                }
                throw new AssertionError();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)fieldType;
                if (arrayType.getElementType().isAnyOf(new LogicalTypeFamily[]{LogicalTypeFamily.CONSTRUCTED})) {
                    return new ArrayGroupReader((ColumnReader<WritableColumnVector>)ParquetSplitReaderUtil.createColumnReader(utcTimestamp, arrayType.getElementType(), physicalType.asGroupType().getType(0), descriptors, pages, depth + 1));
                }
                return new ArrayColumnReader(descriptor, pageReader, utcTimestamp, (Type)descriptor.getPrimitiveType(), fieldType);
            }
            case MAP: {
                MapType mapType = (MapType)fieldType;
                ArrayColumnReader keyReader = new ArrayColumnReader(descriptor, pageReader, utcTimestamp, (Type)descriptor.getPrimitiveType(), (LogicalType)new ArrayType(mapType.getKeyType()));
                Object valueReader = mapType.getValueType().isAnyOf(new LogicalTypeFamily[]{LogicalTypeFamily.CONSTRUCTED}) ? new ArrayGroupReader((ColumnReader<WritableColumnVector>)ParquetSplitReaderUtil.createColumnReader(utcTimestamp, mapType.getValueType(), physicalType.asGroupType().getType(0).asGroupType().getType(1), descriptors.subList(1, descriptors.size()), pages, depth + 2)) : new ArrayColumnReader(descriptors.get(1), pages.getPageReader(descriptors.get(1)), utcTimestamp, (Type)descriptors.get(1).getPrimitiveType(), (LogicalType)new ArrayType(mapType.getValueType()));
                return new MapColumnReader(keyReader, (ColumnReader<WritableColumnVector>)valueReader);
            }
            case ROW: {
                RowType rowType = (RowType)fieldType;
                GroupType groupType = physicalType.asGroupType();
                ArrayList<ColumnReader> fieldReaders = new ArrayList<ColumnReader>();
                for (int i = 0; i < rowType.getFieldCount(); ++i) {
                    int fieldIndex = ParquetSplitReaderUtil.getFieldIndexInPhysicalType(((RowType.RowField)rowType.getFields().get(i)).getName(), groupType);
                    if (fieldIndex < 0) {
                        fieldReaders.add(new EmptyColumnReader());
                        continue;
                    }
                    if (descriptors.get(fieldIndex).getMaxRepetitionLevel() > 0 && !rowType.getTypeAt(i).is(LogicalTypeRoot.ARRAY)) {
                        fieldReaders.add(ParquetSplitReaderUtil.createColumnReader(utcTimestamp, (LogicalType)new ArrayType(rowType.getTypeAt(i).isNullable(), rowType.getTypeAt(i)), groupType.getType(fieldIndex), descriptors, pages, depth + 1));
                        continue;
                    }
                    fieldReaders.add(ParquetSplitReaderUtil.createColumnReader(utcTimestamp, rowType.getTypeAt(i), groupType.getType(fieldIndex), descriptors, pages, depth + 1));
                }
                return new RowColumnReader(fieldReaders);
            }
        }
        throw new UnsupportedOperationException(fieldType + " is not supported now.");
    }

    public static WritableColumnVector createWritableColumnVector(int batchSize, LogicalType fieldType, Type physicalType, List<ColumnDescriptor> descriptors) {
        return ParquetSplitReaderUtil.createWritableColumnVector(batchSize, fieldType, physicalType, descriptors, 0);
    }

    private static WritableColumnVector createWritableColumnVector(int batchSize, LogicalType fieldType, Type physicalType, List<ColumnDescriptor> columns, int depth) {
        List<ColumnDescriptor> descriptors = ParquetSplitReaderUtil.filterDescriptors(depth, physicalType, columns);
        PrimitiveType primitiveType = descriptors.get(0).getPrimitiveType();
        PrimitiveType.PrimitiveTypeName typeName = primitiveType.getPrimitiveTypeName();
        switch (fieldType.getTypeRoot()) {
            case BOOLEAN: {
                org.apache.parquet.Preconditions.checkArgument((typeName == PrimitiveType.PrimitiveTypeName.BOOLEAN ? 1 : 0) != 0, (String)ParquetSplitReaderUtil.getPrimitiveTypeCheckFailureMessage(typeName, fieldType));
                return new HeapBooleanVector(batchSize);
            }
            case TINYINT: {
                org.apache.parquet.Preconditions.checkArgument((typeName == PrimitiveType.PrimitiveTypeName.INT32 ? 1 : 0) != 0, (String)ParquetSplitReaderUtil.getPrimitiveTypeCheckFailureMessage(typeName, fieldType));
                return new HeapByteVector(batchSize);
            }
            case DOUBLE: {
                org.apache.parquet.Preconditions.checkArgument((typeName == PrimitiveType.PrimitiveTypeName.DOUBLE ? 1 : 0) != 0, (String)ParquetSplitReaderUtil.getPrimitiveTypeCheckFailureMessage(typeName, fieldType));
                return new HeapDoubleVector(batchSize);
            }
            case FLOAT: {
                org.apache.parquet.Preconditions.checkArgument((typeName == PrimitiveType.PrimitiveTypeName.FLOAT ? 1 : 0) != 0, (String)ParquetSplitReaderUtil.getPrimitiveTypeCheckFailureMessage(typeName, fieldType));
                return new HeapFloatVector(batchSize);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                org.apache.parquet.Preconditions.checkArgument((typeName == PrimitiveType.PrimitiveTypeName.INT32 ? 1 : 0) != 0, (String)ParquetSplitReaderUtil.getPrimitiveTypeCheckFailureMessage(typeName, fieldType));
                return new HeapIntVector(batchSize);
            }
            case BIGINT: {
                org.apache.parquet.Preconditions.checkArgument((typeName == PrimitiveType.PrimitiveTypeName.INT64 ? 1 : 0) != 0, (String)ParquetSplitReaderUtil.getPrimitiveTypeCheckFailureMessage(typeName, fieldType));
                return new HeapLongVector(batchSize);
            }
            case SMALLINT: {
                org.apache.parquet.Preconditions.checkArgument((typeName == PrimitiveType.PrimitiveTypeName.INT32 ? 1 : 0) != 0, (String)ParquetSplitReaderUtil.getPrimitiveTypeCheckFailureMessage(typeName, fieldType));
                return new HeapShortVector(batchSize);
            }
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                org.apache.parquet.Preconditions.checkArgument((typeName == PrimitiveType.PrimitiveTypeName.BINARY ? 1 : 0) != 0, (String)ParquetSplitReaderUtil.getPrimitiveTypeCheckFailureMessage(typeName, fieldType));
                return new HeapBytesVector(batchSize);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                org.apache.parquet.Preconditions.checkArgument((primitiveType.getOriginalType() != OriginalType.TIME_MICROS ? 1 : 0) != 0, (String)ParquetSplitReaderUtil.getOriginalTypeCheckFailureMessage(primitiveType.getOriginalType(), fieldType));
                return new HeapTimestampVector(batchSize);
            }
            case DECIMAL: {
                org.apache.parquet.Preconditions.checkArgument(((typeName == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY || typeName == PrimitiveType.PrimitiveTypeName.BINARY) && primitiveType.getOriginalType() == OriginalType.DECIMAL ? 1 : 0) != 0, (String)ParquetSplitReaderUtil.getPrimitiveTypeCheckFailureMessage(typeName, fieldType));
                return new HeapDecimalVector(batchSize);
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)fieldType;
                if (arrayType.getElementType().isAnyOf(new LogicalTypeFamily[]{LogicalTypeFamily.CONSTRUCTED})) {
                    return new HeapArrayGroupColumnVector(batchSize, ParquetSplitReaderUtil.createWritableColumnVector(batchSize, arrayType.getElementType(), physicalType.asGroupType().getType(0), descriptors, depth + 1));
                }
                return new HeapArrayVector(batchSize, (ColumnVector)ParquetSplitReaderUtil.createWritableColumnVector(batchSize, arrayType.getElementType(), physicalType, descriptors, depth));
            }
            case MAP: {
                MapType mapType = (MapType)fieldType;
                GroupType repeatedType = physicalType.asGroupType().getType(0).asGroupType();
                WritableColumnVector keyColumnVector = ParquetSplitReaderUtil.createWritableColumnVector(batchSize, (LogicalType)new ArrayType(mapType.getKeyType().isNullable(), mapType.getKeyType()), repeatedType.getType(0), descriptors, depth + 2);
                HeapArrayGroupColumnVector valueColumnVector = mapType.getValueType().isAnyOf(new LogicalTypeFamily[]{LogicalTypeFamily.CONSTRUCTED}) ? new HeapArrayGroupColumnVector(batchSize, ParquetSplitReaderUtil.createWritableColumnVector(batchSize, mapType.getValueType(), (Type)repeatedType.getType(1).asGroupType(), descriptors, depth + 2)) : ParquetSplitReaderUtil.createWritableColumnVector(batchSize, (LogicalType)new ArrayType(mapType.getValueType().isNullable(), mapType.getValueType()), repeatedType.getType(1), descriptors, depth + 2);
                return new HeapMapColumnVector(batchSize, keyColumnVector, valueColumnVector);
            }
            case ROW: {
                RowType rowType = (RowType)fieldType;
                GroupType groupType = physicalType.asGroupType();
                WritableColumnVector[] columnVectors = new WritableColumnVector[rowType.getFieldCount()];
                for (int i = 0; i < columnVectors.length; ++i) {
                    int fieldIndex = ParquetSplitReaderUtil.getFieldIndexInPhysicalType(((RowType.RowField)rowType.getFields().get(i)).getName(), groupType);
                    if (fieldIndex < 0) {
                        if (groupType.getRepetition().equals((Object)Type.Repetition.REPEATED) && !rowType.getTypeAt(i).is(LogicalTypeRoot.ARRAY)) {
                            columnVectors[i] = (WritableColumnVector)ParquetSplitReaderUtil.createVectorFromConstant((LogicalType)new ArrayType(rowType.getTypeAt(i).isNullable(), rowType.getTypeAt(i)), null, batchSize);
                            continue;
                        }
                        columnVectors[i] = (WritableColumnVector)ParquetSplitReaderUtil.createVectorFromConstant(rowType.getTypeAt(i), null, batchSize);
                        continue;
                    }
                    columnVectors[i] = descriptors.get(fieldIndex).getMaxRepetitionLevel() > 0 && !rowType.getTypeAt(i).is(LogicalTypeRoot.ARRAY) ? ParquetSplitReaderUtil.createWritableColumnVector(batchSize, (LogicalType)new ArrayType(rowType.getTypeAt(i).isNullable(), rowType.getTypeAt(i)), groupType.getType(fieldIndex), descriptors, depth + 1) : ParquetSplitReaderUtil.createWritableColumnVector(batchSize, rowType.getTypeAt(i), groupType.getType(fieldIndex), descriptors, depth + 1);
                }
                return new HeapRowColumnVector(batchSize, columnVectors);
            }
        }
        throw new UnsupportedOperationException(fieldType + " is not supported now.");
    }

    private static int getFieldIndexInPhysicalType(String fieldName, GroupType groupType) {
        return groupType.containsField(fieldName) ? groupType.getFieldIndex(fieldName) : -1;
    }

    private static String getPrimitiveTypeCheckFailureMessage(PrimitiveType.PrimitiveTypeName primitiveType, LogicalType fieldType) {
        return String.format("Unexpected type exception. Primitive type: %s. Field type: %s.", primitiveType, fieldType.getTypeRoot().name());
    }

    private static String getOriginalTypeCheckFailureMessage(OriginalType originalType, LogicalType fieldType) {
        return String.format("Unexpected type exception. Original type: %s. Field type: %s.", originalType, fieldType.getTypeRoot().name());
    }
}

