/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.SlashEncodedDayPartitionValueExtractor;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;

@ConfigClassProperty(name="Flink Options", groupName=ConfigGroups.Names.FLINK_SQL, description="Flink jobs using the SQL can be configured through the options in WITH clause. The actual datasource level configs are listed below.")
public class FlinkOptions
extends HoodieConfig {
    public static final ConfigOption<String> PATH = ConfigOptions.key((String)"path").stringType().noDefaultValue().withDescription("Base path for the target hoodie table.\nThe path would be created if it does not exist,\notherwise a Hoodie table expects to be initialized successfully");
    public static final ConfigOption<String> PARTITION_DEFAULT_NAME = ConfigOptions.key((String)"partition.default_name").stringType().defaultValue((Object)"default").withDescription("The default partition name in case the dynamic partition column value is null/empty string");
    public static final ConfigOption<Boolean> CHANGELOG_ENABLED = ConfigOptions.key((String)"changelog.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to keep all the intermediate changes, we try to keep all the changes of a record when enabled:\n1). The sink accept the UPDATE_BEFORE message;\n2). The source try to emit every changes of a record.\nThe semantics is best effort because the compaction job would finally merge all changes of a record into one.\n default false to have UPSERT semantics");
    public static final ConfigOption<Boolean> METADATA_ENABLED = ConfigOptions.key((String)"metadata.enabled").booleanType().defaultValue((Object)false).withDescription("Enable the internal metadata table which serves table metadata like level file listings, default false");
    public static final ConfigOption<Integer> METADATA_COMPACTION_DELTA_COMMITS = ConfigOptions.key((String)"metadata.compaction.delta_commits").intType().defaultValue((Object)10).withDescription("Max delta commits for metadata table to trigger compaction, default 24");
    public static final ConfigOption<Boolean> INDEX_BOOTSTRAP_ENABLED = ConfigOptions.key((String)"index.bootstrap.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to bootstrap the index state from existing hoodie table, default false");
    public static final ConfigOption<Double> INDEX_STATE_TTL = ConfigOptions.key((String)"index.state.ttl").doubleType().defaultValue((Object)0.0).withDescription("Index state ttl in days, default stores the index permanently");
    public static final ConfigOption<Boolean> INDEX_GLOBAL_ENABLED = ConfigOptions.key((String)"index.global.enabled").booleanType().defaultValue((Object)true).withDescription("Whether to update index for the old partition path\nif same key record with different partition path came in, default true");
    public static final ConfigOption<String> INDEX_PARTITION_REGEX = ConfigOptions.key((String)"index.partition.regex").stringType().defaultValue((Object)".*").withDescription("Whether to load partitions in state if partition path matching\uff0c default *");
    public static final ConfigOption<Integer> READ_TASKS = ConfigOptions.key((String)"read.tasks").intType().defaultValue((Object)4).withDescription("Parallelism of tasks that do actual read, default is 4");
    public static final ConfigOption<String> SOURCE_AVRO_SCHEMA_PATH = ConfigOptions.key((String)"source.avro-schema.path").stringType().noDefaultValue().withDescription("Source avro schema file path, the parsed schema is used for deserialization");
    public static final ConfigOption<String> SOURCE_AVRO_SCHEMA = ConfigOptions.key((String)"source.avro-schema").stringType().noDefaultValue().withDescription("Source avro schema string, the parsed schema is used for deserialization");
    public static final String QUERY_TYPE_SNAPSHOT = "snapshot";
    public static final String QUERY_TYPE_READ_OPTIMIZED = "read_optimized";
    public static final String QUERY_TYPE_INCREMENTAL = "incremental";
    public static final ConfigOption<String> QUERY_TYPE = ConfigOptions.key((String)"hoodie.datasource.query.type").stringType().defaultValue((Object)"snapshot").withDescription("Decides how data files need to be read, in\n1) Snapshot mode (obtain latest view, based on row & columnar data);\n2) incremental mode (new data since an instantTime);\n3) Read Optimized mode (obtain latest view, based on columnar data)\n.Default: snapshot");
    public static final String REALTIME_SKIP_MERGE = "skip_merge";
    public static final String REALTIME_PAYLOAD_COMBINE = "payload_combine";
    public static final ConfigOption<String> MERGE_TYPE = ConfigOptions.key((String)"hoodie.datasource.merge.type").stringType().defaultValue((Object)"payload_combine").withDescription("For Snapshot query on merge on read table. Use this key to define how the payloads are merged, in\n1) skip_merge: read the base file records plus the log file records;\n2) payload_combine: read the base file records first, for each record in base file, checks whether the key is in the\n   log file records(combines the two records with same key for base and log file records), then read the left log file records");
    public static final ConfigOption<Boolean> UTC_TIMEZONE = ConfigOptions.key((String)"read.utc-timezone").booleanType().defaultValue((Object)true).withDescription("Use UTC timezone or local timezone to the conversion between epoch time and LocalDateTime. Hive 0.x/1.x/2.x use local timezone. But Hive 3.x use UTC timezone, by default true");
    public static final ConfigOption<Boolean> READ_AS_STREAMING = ConfigOptions.key((String)"read.streaming.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to read as streaming source, default false");
    public static final ConfigOption<Integer> READ_STREAMING_CHECK_INTERVAL = ConfigOptions.key((String)"read.streaming.check-interval").intType().defaultValue((Object)60).withDescription("Check interval for streaming read of SECOND, default 1 minute");
    public static final ConfigOption<Boolean> READ_STREAMING_SKIP_COMPACT = ConfigOptions.key((String)"read.streaming.skip_compaction").booleanType().defaultValue((Object)false).withDescription("Whether to skip compaction instants for streaming read,\nthere are two cases that this option can be used to avoid reading duplicates:\n1) you are definitely sure that the consumer reads faster than any compaction instants, usually with delta time compaction strategy that is long enough, for e.g, one week;\n2) changelog mode is enabled, this option is a solution to keep data integrity");
    public static final String START_COMMIT_EARLIEST = "earliest";
    public static final ConfigOption<String> READ_START_COMMIT = ConfigOptions.key((String)"read.start-commit").stringType().noDefaultValue().withDescription("Start commit instant for reading, the commit time format should be 'yyyyMMddHHmmss', by default reading from the latest instant for streaming read");
    public static final ConfigOption<String> READ_END_COMMIT = ConfigOptions.key((String)"read.end-commit").stringType().noDefaultValue().withDescription("End commit instant for reading, the commit time format should be 'yyyyMMddHHmmss'");
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)HoodieWriteConfig.TBL_NAME.key()).stringType().noDefaultValue().withDescription("Table name to register to Hive metastore");
    public static final String TABLE_TYPE_COPY_ON_WRITE = HoodieTableType.COPY_ON_WRITE.name();
    public static final String TABLE_TYPE_MERGE_ON_READ = HoodieTableType.MERGE_ON_READ.name();
    public static final ConfigOption<String> TABLE_TYPE = ConfigOptions.key((String)"table.type").stringType().defaultValue((Object)TABLE_TYPE_COPY_ON_WRITE).withDescription("Type of table to write. COPY_ON_WRITE (or) MERGE_ON_READ");
    public static final ConfigOption<Boolean> INSERT_CLUSTER = ConfigOptions.key((String)"write.insert.cluster").booleanType().defaultValue((Object)false).withDescription("Whether to merge small files for insert mode, if true, the write throughput will decrease because the read/write of existing small file, only valid for COW table, default false");
    public static final ConfigOption<String> OPERATION = ConfigOptions.key((String)"write.operation").stringType().defaultValue((Object)"upsert").withDescription("The write operation, that this write should do");
    public static final String NO_PRE_COMBINE = "no_precombine";
    public static final ConfigOption<String> PRECOMBINE_FIELD = ConfigOptions.key((String)"write.precombine.field").stringType().defaultValue((Object)"ts").withDescription("Field used in preCombining before actual write. When two records have the same\nkey value, we will pick the one with the largest value for the precombine field,\ndetermined by Object.compareTo(..)");
    public static final ConfigOption<String> PAYLOAD_CLASS_NAME = ConfigOptions.key((String)"write.payload.class").stringType().defaultValue((Object)OverwriteWithLatestAvroPayload.class.getName()).withDescription("Payload class used. Override this, if you like to roll your own merge logic, when upserting/inserting.\nThis will render any value set for the option in-effective");
    public static final ConfigOption<Boolean> PRE_COMBINE = ConfigOptions.key((String)"write.precombine").booleanType().defaultValue((Object)false).withDescription("Flag to indicate whether to drop duplicates before insert/upsert.\nBy default these cases will accept duplicates, to gain extra performance:\n1) insert operation;\n2) upsert for MOR table, the MOR table deduplicate on reading");
    public static final ConfigOption<Integer> RETRY_TIMES = ConfigOptions.key((String)"write.retry.times").intType().defaultValue((Object)3).withDescription("Flag to indicate how many times streaming job should retry for a failed checkpoint batch.\nBy default 3");
    public static final ConfigOption<Long> RETRY_INTERVAL_MS = ConfigOptions.key((String)"write.retry.interval.ms").longType().defaultValue((Object)2000L).withDescription("Flag to indicate how long (by millisecond) before a retry should issued for failed checkpoint batch.\nBy default 2000 and it will be doubled by every retry");
    public static final ConfigOption<Boolean> IGNORE_FAILED = ConfigOptions.key((String)"write.ignore.failed").booleanType().defaultValue((Object)true).withDescription("Flag to indicate whether to ignore any non exception error (e.g. writestatus error). within a checkpoint batch.\nBy default true (in favor of streaming progressing over data integrity)");
    public static final ConfigOption<String> RECORD_KEY_FIELD = ConfigOptions.key((String)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).stringType().defaultValue((Object)"uuid").withDescription("Record key field. Value to be used as the `recordKey` component of `HoodieKey`.\nActual value will be obtained by invoking .toString() on the field value. Nested fields can be specified using the dot notation eg: `a.b.c`");
    public static final ConfigOption<String> PARTITION_PATH_FIELD = ConfigOptions.key((String)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()).stringType().defaultValue((Object)"").withDescription("Partition path field. Value to be used at the `partitionPath` component of `HoodieKey`.\nActual value obtained by invoking .toString(), default ''");
    public static final ConfigOption<Boolean> URL_ENCODE_PARTITIONING = ConfigOptions.key((String)KeyGeneratorOptions.URL_ENCODE_PARTITIONING.key()).booleanType().defaultValue((Object)false).withDescription("Whether to encode the partition path url, default false");
    public static final ConfigOption<Boolean> HIVE_STYLE_PARTITIONING = ConfigOptions.key((String)KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key()).booleanType().defaultValue((Object)false).withDescription("Whether to use Hive style partitioning.\nIf set true, the names of partition folders follow <partition_column_name>=<partition_value> format.\nBy default false (the names of partition folders are only partition values)");
    public static final ConfigOption<String> KEYGEN_CLASS_NAME = ConfigOptions.key((String)HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key()).stringType().defaultValue((Object)"").withDescription("Key generator class, that implements will extract the key out of incoming record");
    public static final ConfigOption<String> KEYGEN_TYPE = ConfigOptions.key((String)HoodieWriteConfig.KEYGENERATOR_TYPE.key()).stringType().defaultValue((Object)KeyGeneratorType.SIMPLE.name()).withDescription("Key generator type, that implements will extract the key out of incoming record");
    public static final String PARTITION_FORMAT_HOUR = "yyyyMMddHH";
    public static final String PARTITION_FORMAT_DAY = "yyyyMMdd";
    public static final ConfigOption<String> PARTITION_FORMAT = ConfigOptions.key((String)"write.partition.format").stringType().noDefaultValue().withDescription("Partition path format, only valid when 'write.datetime.partitioning' is true, default is:\n1) 'yyyyMMddHH' for timestamp(3) WITHOUT TIME ZONE, LONG, FLOAT, DOUBLE, DECIMAL;\n2) 'yyyyMMdd' for DAY and INT.");
    public static final ConfigOption<Integer> INDEX_BOOTSTRAP_TASKS = ConfigOptions.key((String)"write.index_bootstrap.tasks").intType().noDefaultValue().withDescription("Parallelism of tasks that do index bootstrap, default is the parallelism of the execution environment");
    public static final ConfigOption<Integer> BUCKET_ASSIGN_TASKS = ConfigOptions.key((String)"write.bucket_assign.tasks").intType().noDefaultValue().withDescription("Parallelism of tasks that do bucket assign, default is the parallelism of the execution environment");
    public static final ConfigOption<Integer> WRITE_TASKS = ConfigOptions.key((String)"write.tasks").intType().defaultValue((Object)4).withDescription("Parallelism of tasks that do actual write, default is 4");
    public static final ConfigOption<Double> WRITE_TASK_MAX_SIZE = ConfigOptions.key((String)"write.task.max.size").doubleType().defaultValue((Object)1024.0).withDescription("Maximum memory in MB for a write task, when the threshold hits,\nit flushes the max size data bucket to avoid OOM, default 1GB");
    public static final ConfigOption<Long> WRITE_RATE_LIMIT = ConfigOptions.key((String)"write.rate.limit").longType().defaultValue((Object)0L).withDescription("Write record rate limit per second to prevent traffic jitter and improve stability, default 0 (no limit)");
    public static final ConfigOption<Double> WRITE_BATCH_SIZE = ConfigOptions.key((String)"write.batch.size").doubleType().defaultValue((Object)256.0).withDescription("Batch buffer size in MB to flush data into the underneath filesystem, default 256MB");
    public static final ConfigOption<Integer> WRITE_LOG_BLOCK_SIZE = ConfigOptions.key((String)"write.log_block.size").intType().defaultValue((Object)128).withDescription("Max log block size in MB for log file, default 128MB");
    public static final ConfigOption<Long> WRITE_LOG_MAX_SIZE = ConfigOptions.key((String)"write.log.max.size").longType().defaultValue((Object)1024L).withDescription("Maximum size allowed in MB for a log file before it is rolled over to the next version, default 1GB");
    public static final ConfigOption<Integer> WRITE_PARQUET_BLOCK_SIZE = ConfigOptions.key((String)"write.parquet.block.size").intType().defaultValue((Object)120).withDescription("Parquet RowGroup size. It's recommended to make this large enough that scan costs can be amortized by packing enough column values into a single row group.");
    public static final ConfigOption<Integer> WRITE_PARQUET_MAX_FILE_SIZE = ConfigOptions.key((String)"write.parquet.max.file.size").intType().defaultValue((Object)120).withDescription("Target size for parquet files produced by Hudi write phases. For DFS, this needs to be aligned with the underlying filesystem block size for optimal performance.");
    public static final ConfigOption<Integer> WRITE_PARQUET_PAGE_SIZE = ConfigOptions.key((String)"write.parquet.page.size").intType().defaultValue((Object)1).withDescription("Parquet page size. Page is the unit of read within a parquet file. Within a block, pages are compressed separately.");
    public static final ConfigOption<Integer> WRITE_MERGE_MAX_MEMORY = ConfigOptions.key((String)"write.merge.max_memory").intType().defaultValue((Object)100).withDescription("Max memory in MB for merge, default 100MB");
    public static final ConfigOption<Long> WRITE_COMMIT_ACK_TIMEOUT = ConfigOptions.key((String)"write.commit.ack.timeout").longType().defaultValue((Object)-1L).withDescription("Timeout limit for a writer task after it finishes a checkpoint and\nwaits for the instant commit success, only for internal use");
    public static final ConfigOption<Boolean> WRITE_BULK_INSERT_SHUFFLE_BY_PARTITION = ConfigOptions.key((String)"write.bulk_insert.shuffle_by_partition").booleanType().defaultValue((Object)true).withDescription("Whether to shuffle the inputs by partition path for bulk insert tasks, default true");
    public static final ConfigOption<Boolean> WRITE_BULK_INSERT_SORT_BY_PARTITION = ConfigOptions.key((String)"write.bulk_insert.sort_by_partition").booleanType().defaultValue((Object)true).withDescription("Whether to sort the inputs by partition path for bulk insert tasks, default true");
    public static final ConfigOption<Integer> WRITE_SORT_MEMORY = ConfigOptions.key((String)"write.sort.memory").intType().defaultValue((Object)128).withDescription("Sort memory in MB, default 128MB");
    public static final ConfigOption<Boolean> COMPACTION_SCHEDULE_ENABLED = ConfigOptions.key((String)"compaction.schedule.enabled").booleanType().defaultValue((Object)true).withDescription("Schedule the compaction plan, enabled by default for MOR");
    public static final ConfigOption<Boolean> COMPACTION_ASYNC_ENABLED = ConfigOptions.key((String)"compaction.async.enabled").booleanType().defaultValue((Object)true).withDescription("Async Compaction, enabled by default for MOR");
    public static final ConfigOption<Integer> COMPACTION_TASKS = ConfigOptions.key((String)"compaction.tasks").intType().defaultValue((Object)4).withDescription("Parallelism of tasks that do actual compaction, default is 4");
    public static final String NUM_COMMITS = "num_commits";
    public static final String TIME_ELAPSED = "time_elapsed";
    public static final String NUM_AND_TIME = "num_and_time";
    public static final String NUM_OR_TIME = "num_or_time";
    public static final ConfigOption<String> COMPACTION_TRIGGER_STRATEGY = ConfigOptions.key((String)"compaction.trigger.strategy").stringType().defaultValue((Object)"num_commits").withDescription("Strategy to trigger compaction, options are 'num_commits': trigger compaction when reach N delta commits;\n'time_elapsed': trigger compaction when time elapsed > N seconds since last compaction;\n'num_and_time': trigger compaction when both NUM_COMMITS and TIME_ELAPSED are satisfied;\n'num_or_time': trigger compaction when NUM_COMMITS or TIME_ELAPSED is satisfied.\nDefault is 'num_commits'");
    public static final ConfigOption<Integer> COMPACTION_DELTA_COMMITS = ConfigOptions.key((String)"compaction.delta_commits").intType().defaultValue((Object)5).withDescription("Max delta commits needed to trigger compaction, default 5 commits");
    public static final ConfigOption<Integer> COMPACTION_DELTA_SECONDS = ConfigOptions.key((String)"compaction.delta_seconds").intType().defaultValue((Object)3600).withDescription("Max delta seconds time needed to trigger compaction, default 1 hour");
    public static final ConfigOption<Integer> COMPACTION_TIMEOUT_SECONDS = ConfigOptions.key((String)"compaction.timeout.seconds").intType().defaultValue((Object)1200).withDescription("Max timeout time in seconds for online compaction to rollback, default 20 minutes");
    public static final ConfigOption<Integer> COMPACTION_MAX_MEMORY = ConfigOptions.key((String)"compaction.max_memory").intType().defaultValue((Object)100).withDescription("Max memory in MB for compaction spillable map, default 100MB");
    public static final ConfigOption<Long> COMPACTION_TARGET_IO = ConfigOptions.key((String)"compaction.target_io").longType().defaultValue((Object)512000L).withDescription("Target IO per compaction (both read and write), default 500 GB");
    public static final ConfigOption<Boolean> CLEAN_ASYNC_ENABLED = ConfigOptions.key((String)"clean.async.enabled").booleanType().defaultValue((Object)true).withDescription("Whether to cleanup the old commits immediately on new commits, enabled by default");
    public static final ConfigOption<Integer> CLEAN_RETAIN_COMMITS = ConfigOptions.key((String)"clean.retain_commits").intType().defaultValue((Object)10).withDescription("Number of commits to retain. So data will be retained for num_of_commits * time_between_commits (scheduled).\nThis also directly translates into how much you can incrementally pull on this table, default 10");
    public static final ConfigOption<Integer> ARCHIVE_MAX_COMMITS = ConfigOptions.key((String)"archive.max_commits").intType().defaultValue((Object)30).withDescription("Max number of commits to keep before archiving older commits into a sequential log, default 30");
    public static final ConfigOption<Integer> ARCHIVE_MIN_COMMITS = ConfigOptions.key((String)"archive.min_commits").intType().defaultValue((Object)20).withDescription("Min number of commits to keep before archiving older commits into a sequential log, default 20");
    public static final ConfigOption<Boolean> HIVE_SYNC_ENABLED = ConfigOptions.key((String)"hive_sync.enable").booleanType().defaultValue((Object)false).withDescription("Asynchronously sync Hive meta to HMS, default false");
    public static final ConfigOption<String> HIVE_SYNC_DB = ConfigOptions.key((String)"hive_sync.db").stringType().defaultValue((Object)"default").withDescription("Database name for hive sync, default 'default'");
    public static final ConfigOption<String> HIVE_SYNC_TABLE = ConfigOptions.key((String)"hive_sync.table").stringType().defaultValue((Object)"unknown").withDescription("Table name for hive sync, default 'unknown'");
    public static final ConfigOption<String> HIVE_SYNC_FILE_FORMAT = ConfigOptions.key((String)"hive_sync.file_format").stringType().defaultValue((Object)"PARQUET").withDescription("File format for hive sync, default 'PARQUET'");
    public static final ConfigOption<String> HIVE_SYNC_MODE = ConfigOptions.key((String)"hive_sync.mode").stringType().defaultValue((Object)"jdbc").withDescription("Mode to choose for Hive ops. Valid values are hms, jdbc and hiveql, default 'jdbc'");
    public static final ConfigOption<String> HIVE_SYNC_USERNAME = ConfigOptions.key((String)"hive_sync.username").stringType().defaultValue((Object)"hive").withDescription("Username for hive sync, default 'hive'");
    public static final ConfigOption<String> HIVE_SYNC_PASSWORD = ConfigOptions.key((String)"hive_sync.password").stringType().defaultValue((Object)"hive").withDescription("Password for hive sync, default 'hive'");
    public static final ConfigOption<String> HIVE_SYNC_JDBC_URL = ConfigOptions.key((String)"hive_sync.jdbc_url").stringType().defaultValue((Object)"jdbc:hive2://localhost:10000").withDescription("Jdbc URL for hive sync, default 'jdbc:hive2://localhost:10000'");
    public static final ConfigOption<String> HIVE_SYNC_METASTORE_URIS = ConfigOptions.key((String)"hive_sync.metastore.uris").stringType().defaultValue((Object)"").withDescription("Metastore uris for hive sync, default ''");
    public static final ConfigOption<String> HIVE_SYNC_PARTITION_FIELDS = ConfigOptions.key((String)"hive_sync.partition_fields").stringType().defaultValue((Object)"").withDescription("Partition fields for hive sync, default ''");
    public static final ConfigOption<String> HIVE_SYNC_PARTITION_EXTRACTOR_CLASS_NAME = ConfigOptions.key((String)"hive_sync.partition_extractor_class").stringType().defaultValue((Object)SlashEncodedDayPartitionValueExtractor.class.getCanonicalName()).withDescription("Tool to extract the partition value from HDFS path, default 'SlashEncodedDayPartitionValueExtractor'");
    public static final ConfigOption<Boolean> HIVE_SYNC_ASSUME_DATE_PARTITION = ConfigOptions.key((String)"hive_sync.assume_date_partitioning").booleanType().defaultValue((Object)false).withDescription("Assume partitioning is yyyy/mm/dd, default false");
    public static final ConfigOption<Boolean> HIVE_SYNC_USE_JDBC = ConfigOptions.key((String)"hive_sync.use_jdbc").booleanType().defaultValue((Object)true).withDescription("Use JDBC when hive synchronization is enabled, default true");
    public static final ConfigOption<Boolean> HIVE_SYNC_AUTO_CREATE_DB = ConfigOptions.key((String)"hive_sync.auto_create_db").booleanType().defaultValue((Object)true).withDescription("Auto create hive database if it does not exists, default true");
    public static final ConfigOption<Boolean> HIVE_SYNC_IGNORE_EXCEPTIONS = ConfigOptions.key((String)"hive_sync.ignore_exceptions").booleanType().defaultValue((Object)false).withDescription("Ignore exceptions during hive synchronization, default false");
    public static final ConfigOption<Boolean> HIVE_SYNC_SKIP_RO_SUFFIX = ConfigOptions.key((String)"hive_sync.skip_ro_suffix").booleanType().defaultValue((Object)false).withDescription("Skip the _ro suffix for Read optimized table when registering, default false");
    public static final ConfigOption<Boolean> HIVE_SYNC_SUPPORT_TIMESTAMP = ConfigOptions.key((String)"hive_sync.support_timestamp").booleanType().defaultValue((Object)false).withDescription("INT64 with original type TIMESTAMP_MICROS is converted to hive timestamp type.\nDisabled by default for backward compatibility.");
    private static final String PROPERTIES_PREFIX = "properties.";

    private FlinkOptions() {
    }

    public static Map<String, String> getHoodieProperties(Map<String, String> options) {
        return FlinkOptions.getHoodiePropertiesWithPrefix(options, PROPERTIES_PREFIX);
    }

    public static Map<String, String> getHoodiePropertiesWithPrefix(Map<String, String> options, String prefix) {
        HashMap<String, String> hoodieProperties = new HashMap<String, String>();
        if (FlinkOptions.hasPropertyOptions(options)) {
            options.keySet().stream().filter(key -> key.startsWith(PROPERTIES_PREFIX)).forEach(key -> {
                String value = (String)options.get(key);
                String subKey = key.substring(prefix.length());
                hoodieProperties.put(subKey, value);
            });
        }
        return hoodieProperties;
    }

    public static Configuration flatOptions(Configuration conf) {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        conf.toMap().forEach((key, value) -> {
            String subKey = key.startsWith(PROPERTIES_PREFIX) ? key.substring(PROPERTIES_PREFIX.length()) : key;
            propsMap.put(subKey, (String)value);
        });
        return FlinkOptions.fromMap(propsMap);
    }

    private static boolean hasPropertyOptions(Map<String, String> options) {
        return options.keySet().stream().anyMatch(k -> k.startsWith(PROPERTIES_PREFIX));
    }

    public static Configuration fromMap(Map<String, String> map) {
        Configuration configuration = new Configuration();
        map.forEach((arg_0, arg_1) -> ((Configuration)configuration).setString(arg_0, arg_1));
        return configuration;
    }

    public static <T> boolean isDefaultValueDefined(Configuration conf, ConfigOption<T> option) {
        return !conf.getOptional(option).isPresent() || conf.get(option).equals(option.defaultValue());
    }

    public static Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet(FlinkOptions.allOptions());
        options.remove(PATH);
        return options;
    }

    public static List<ConfigOption<?>> allOptions() {
        Field[] declaredFields = FlinkOptions.class.getDeclaredFields();
        ArrayList options = new ArrayList();
        for (Field field : declaredFields) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(ConfigOption.class)) continue;
            try {
                options.add((ConfigOption)field.get(ConfigOption.class));
            }
            catch (IllegalAccessException e) {
                throw new HoodieException("Error while fetching static config option", (Throwable)e);
            }
        }
        return options;
    }
}

