/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.partitioner.profile;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.sink.partitioner.profile.WriteProfile;
import org.apache.hudi.table.action.commit.SmallFile;

public class DeltaWriteProfile
extends WriteProfile {
    public DeltaWriteProfile(HoodieWriteConfig config, HoodieFlinkEngineContext context) {
        super(config, context);
    }

    @Override
    protected List<SmallFile> smallFilesProfile(String partitionPath) {
        ArrayList<SmallFile> smallFileLocations = new ArrayList<SmallFile>();
        HoodieTimeline commitTimeline = this.metaClient.getCommitsTimeline().filterCompletedInstants();
        if (!commitTimeline.empty()) {
            HoodieInstant latestCommitTime = (HoodieInstant)commitTimeline.lastInstant().get();
            ArrayList<FileSlice> allSmallFileSlices = new ArrayList<FileSlice>();
            List allFileSlices = this.fsView.getLatestFileSlicesBeforeOrOn(partitionPath, latestCommitTime.getTimestamp(), true).collect(Collectors.toList());
            for (FileSlice fileSlice : allFileSlices) {
                if (!this.isSmallFile(fileSlice)) continue;
                allSmallFileSlices.add(fileSlice);
            }
            for (FileSlice smallFileSlice : allSmallFileSlices) {
                SmallFile sf = new SmallFile();
                if (smallFileSlice.getBaseFile().isPresent()) {
                    String filename = ((HoodieBaseFile)smallFileSlice.getBaseFile().get()).getFileName();
                    sf.location = new HoodieRecordLocation(FSUtils.getCommitTime((String)filename), FSUtils.getFileId((String)filename));
                    sf.sizeBytes = this.getTotalFileSize(smallFileSlice);
                    smallFileLocations.add(sf);
                    continue;
                }
                smallFileSlice.getLogFiles().findFirst().ifPresent(logFile -> {
                    sf.location = new HoodieRecordLocation(FSUtils.getBaseCommitTimeFromLogPath((Path)logFile.getPath()), FSUtils.getFileIdFromLogPath((Path)logFile.getPath()));
                    sf.sizeBytes = this.getTotalFileSize(smallFileSlice);
                    smallFileLocations.add(sf);
                });
            }
        }
        return smallFileLocations;
    }

    @Override
    protected SyncableFileSystemView getFileSystemView() {
        return (SyncableFileSystemView)this.getTable().getSliceView();
    }

    private long getTotalFileSize(FileSlice fileSlice) {
        if (!fileSlice.getBaseFile().isPresent()) {
            return this.convertLogFilesSizeToExpectedParquetSize(fileSlice.getLogFiles().collect(Collectors.toList()));
        }
        return ((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileSize() + this.convertLogFilesSizeToExpectedParquetSize(fileSlice.getLogFiles().collect(Collectors.toList()));
    }

    private boolean isSmallFile(FileSlice fileSlice) {
        long totalSize = this.getTotalFileSize(fileSlice);
        return totalSize < this.config.getParquetMaxFileSize();
    }

    public long convertLogFilesSizeToExpectedParquetSize(List<HoodieLogFile> hoodieLogFiles) {
        long totalSizeOfLogFiles = hoodieLogFiles.stream().map(HoodieLogFile::getFileSize).filter(size -> size > 0L).reduce(Long::sum).orElse(0L);
        return (long)((double)totalSizeOfLogFiles * this.config.getLogFileToParquetCompressionRatio());
    }
}

